/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChannelAvailableMessages;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChannelAvailableMessages
implements UpdateChannelAvailableMessages {
    private final int identifier;
    private final long channelId;
    private final int availableMinId;

    private ImmutableUpdateChannelAvailableMessages(long channelId, int availableMinId) {
        this.channelId = channelId;
        this.availableMinId = availableMinId;
        this.identifier = UpdateChannelAvailableMessages.super.identifier();
    }

    private ImmutableUpdateChannelAvailableMessages(Builder builder) {
        this.channelId = builder.channelId;
        this.availableMinId = builder.availableMinId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChannelAvailableMessages.super.identifier();
    }

    private ImmutableUpdateChannelAvailableMessages(int identifier, long channelId, int availableMinId) {
        this.identifier = identifier;
        this.channelId = channelId;
        this.availableMinId = availableMinId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public int availableMinId() {
        return this.availableMinId;
    }

    public final ImmutableUpdateChannelAvailableMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChannelAvailableMessages(value, this.channelId, this.availableMinId);
    }

    public final ImmutableUpdateChannelAvailableMessages withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateChannelAvailableMessages(this.identifier, value, this.availableMinId);
    }

    public final ImmutableUpdateChannelAvailableMessages withAvailableMinId(int value) {
        if (this.availableMinId == value) {
            return this;
        }
        return new ImmutableUpdateChannelAvailableMessages(this.identifier, this.channelId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChannelAvailableMessages && this.equalTo(0, (ImmutableUpdateChannelAvailableMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChannelAvailableMessages another) {
        return this.identifier == another.identifier && this.channelId == another.channelId && this.availableMinId == another.availableMinId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + this.availableMinId;
        return h;
    }

    public String toString() {
        return "UpdateChannelAvailableMessages{identifier=" + this.identifier + ", channelId=" + this.channelId + ", availableMinId=" + this.availableMinId + "}";
    }

    public static ImmutableUpdateChannelAvailableMessages of(long channelId, int availableMinId) {
        return new ImmutableUpdateChannelAvailableMessages(channelId, availableMinId);
    }

    public static ImmutableUpdateChannelAvailableMessages copyOf(UpdateChannelAvailableMessages instance) {
        if (instance instanceof ImmutableUpdateChannelAvailableMessages) {
            return (ImmutableUpdateChannelAvailableMessages)instance;
        }
        return ImmutableUpdateChannelAvailableMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_AVAILABLE_MIN_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long channelId;
        private int availableMinId;

        private Builder() {
        }

        public final Builder from(UpdateChannelAvailableMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChannelAvailableMessages) {
                instance = (UpdateChannelAvailableMessages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.availableMinId(instance.availableMinId());
                this.channelId(instance.channelId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder availableMinId(int availableMinId) {
            this.availableMinId = availableMinId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateChannelAvailableMessages build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChannelAvailableMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("availableMinId");
            }
            return "Cannot build UpdateChannelAvailableMessages, some of required attributes are not set " + attributes;
        }
    }
}

