/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChannelMessageForwards;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChannelMessageForwards
implements UpdateChannelMessageForwards {
    private final int identifier;
    private final long channelId;
    private final int id;
    private final int forwards;

    private ImmutableUpdateChannelMessageForwards(long channelId, int id, int forwards) {
        this.channelId = channelId;
        this.id = id;
        this.forwards = forwards;
        this.identifier = UpdateChannelMessageForwards.super.identifier();
    }

    private ImmutableUpdateChannelMessageForwards(Builder builder) {
        this.channelId = builder.channelId;
        this.id = builder.id;
        this.forwards = builder.forwards;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChannelMessageForwards.super.identifier();
    }

    private ImmutableUpdateChannelMessageForwards(int identifier, long channelId, int id, int forwards) {
        this.identifier = identifier;
        this.channelId = channelId;
        this.id = id;
        this.forwards = forwards;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int forwards() {
        return this.forwards;
    }

    public final ImmutableUpdateChannelMessageForwards withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChannelMessageForwards(value, this.channelId, this.id, this.forwards);
    }

    public final ImmutableUpdateChannelMessageForwards withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateChannelMessageForwards(this.identifier, value, this.id, this.forwards);
    }

    public final ImmutableUpdateChannelMessageForwards withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableUpdateChannelMessageForwards(this.identifier, this.channelId, value, this.forwards);
    }

    public final ImmutableUpdateChannelMessageForwards withForwards(int value) {
        if (this.forwards == value) {
            return this;
        }
        return new ImmutableUpdateChannelMessageForwards(this.identifier, this.channelId, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChannelMessageForwards && this.equalTo(0, (ImmutableUpdateChannelMessageForwards)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChannelMessageForwards another) {
        return this.identifier == another.identifier && this.channelId == another.channelId && this.id == another.id && this.forwards == another.forwards;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + this.id;
        h += (h << 5) + this.forwards;
        return h;
    }

    public String toString() {
        return "UpdateChannelMessageForwards{identifier=" + this.identifier + ", channelId=" + this.channelId + ", id=" + this.id + ", forwards=" + this.forwards + "}";
    }

    public static ImmutableUpdateChannelMessageForwards of(long channelId, int id, int forwards) {
        return new ImmutableUpdateChannelMessageForwards(channelId, id, forwards);
    }

    public static ImmutableUpdateChannelMessageForwards copyOf(UpdateChannelMessageForwards instance) {
        if (instance instanceof ImmutableUpdateChannelMessageForwards) {
            return (ImmutableUpdateChannelMessageForwards)instance;
        }
        return ImmutableUpdateChannelMessageForwards.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_FORWARDS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long channelId;
        private int id;
        private int forwards;

        private Builder() {
        }

        public final Builder from(UpdateChannelMessageForwards instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChannelMessageForwards) {
                instance = (UpdateChannelMessageForwards)object;
                this.forwards(instance.forwards());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
                this.channelId(instance.channelId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder forwards(int forwards) {
            this.forwards = forwards;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateChannelMessageForwards build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChannelMessageForwards(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("forwards");
            }
            return "Cannot build UpdateChannelMessageForwards, some of required attributes are not set " + attributes;
        }
    }
}

