/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChannelMessageViews;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChannelMessageViews
implements UpdateChannelMessageViews {
    private final int identifier;
    private final long channelId;
    private final int id;
    private final int views;

    private ImmutableUpdateChannelMessageViews(long channelId, int id, int views) {
        this.channelId = channelId;
        this.id = id;
        this.views = views;
        this.identifier = UpdateChannelMessageViews.super.identifier();
    }

    private ImmutableUpdateChannelMessageViews(Builder builder) {
        this.channelId = builder.channelId;
        this.id = builder.id;
        this.views = builder.views;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChannelMessageViews.super.identifier();
    }

    private ImmutableUpdateChannelMessageViews(int identifier, long channelId, int id, int views) {
        this.identifier = identifier;
        this.channelId = channelId;
        this.id = id;
        this.views = views;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int views() {
        return this.views;
    }

    public final ImmutableUpdateChannelMessageViews withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChannelMessageViews(value, this.channelId, this.id, this.views);
    }

    public final ImmutableUpdateChannelMessageViews withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateChannelMessageViews(this.identifier, value, this.id, this.views);
    }

    public final ImmutableUpdateChannelMessageViews withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableUpdateChannelMessageViews(this.identifier, this.channelId, value, this.views);
    }

    public final ImmutableUpdateChannelMessageViews withViews(int value) {
        if (this.views == value) {
            return this;
        }
        return new ImmutableUpdateChannelMessageViews(this.identifier, this.channelId, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChannelMessageViews && this.equalTo(0, (ImmutableUpdateChannelMessageViews)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChannelMessageViews another) {
        return this.identifier == another.identifier && this.channelId == another.channelId && this.id == another.id && this.views == another.views;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + this.id;
        h += (h << 5) + this.views;
        return h;
    }

    public String toString() {
        return "UpdateChannelMessageViews{identifier=" + this.identifier + ", channelId=" + this.channelId + ", id=" + this.id + ", views=" + this.views + "}";
    }

    public static ImmutableUpdateChannelMessageViews of(long channelId, int id, int views) {
        return new ImmutableUpdateChannelMessageViews(channelId, id, views);
    }

    public static ImmutableUpdateChannelMessageViews copyOf(UpdateChannelMessageViews instance) {
        if (instance instanceof ImmutableUpdateChannelMessageViews) {
            return (ImmutableUpdateChannelMessageViews)instance;
        }
        return ImmutableUpdateChannelMessageViews.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_VIEWS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long channelId;
        private int id;
        private int views;

        private Builder() {
        }

        public final Builder from(UpdateChannelMessageViews instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChannelMessageViews) {
                instance = (UpdateChannelMessageViews)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
                this.channelId(instance.channelId());
                this.views(instance.views());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder views(int views) {
            this.views = views;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateChannelMessageViews build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChannelMessageViews(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("views");
            }
            return "Cannot build UpdateChannelMessageViews, some of required attributes are not set " + attributes;
        }
    }
}

