/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChannelParticipant;
import telegram4j.tl.ExportedChatInvite;
import telegram4j.tl.QtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChannelParticipant;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChannelParticipant
implements UpdateChannelParticipant {
    private final int identifier;
    private final int flags;
    private final long channelId;
    private final int date;
    private final long actorId;
    private final long userId;
    @Nullable
    private final ChannelParticipant prevParticipant;
    @Nullable
    private final ChannelParticipant newParticipant;
    @Nullable
    private final ExportedChatInvite invite;
    private final int qts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateChannelParticipant(long channelId, int date, long actorId, long userId, int qts) {
        this.channelId = channelId;
        this.date = date;
        this.actorId = actorId;
        this.userId = userId;
        this.qts = qts;
        this.prevParticipant = null;
        this.newParticipant = null;
        this.invite = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateChannelParticipant(Builder builder) {
        this.channelId = builder.channelId;
        this.date = builder.date;
        this.actorId = builder.actorId;
        this.userId = builder.userId;
        this.prevParticipant = builder.prevParticipant;
        this.newParticipant = builder.newParticipant;
        this.invite = builder.invite;
        this.qts = builder.qts;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateChannelParticipant(int identifier, int flags, long channelId, int date, long actorId, long userId, @Nullable ChannelParticipant prevParticipant, @Nullable ChannelParticipant newParticipant, @Nullable ExportedChatInvite invite, int qts) {
        this.identifier = identifier;
        this.flags = flags;
        this.channelId = channelId;
        this.date = date;
        this.actorId = actorId;
        this.userId = userId;
        this.prevParticipant = prevParticipant;
        this.newParticipant = newParticipant;
        this.invite = invite;
        this.qts = qts;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateChannelParticipant.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateChannelParticipant.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public long actorId() {
        return this.actorId;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    @Nullable
    public ChannelParticipant prevParticipant() {
        return this.prevParticipant;
    }

    @Override
    @Nullable
    public ChannelParticipant newParticipant() {
        return this.newParticipant;
    }

    @Override
    @Nullable
    public ExportedChatInvite invite() {
        return this.invite;
    }

    @Override
    public int qts() {
        return this.qts;
    }

    public final ImmutableUpdateChannelParticipant withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChannelParticipant(value, this.flags, this.channelId, this.date, this.actorId, this.userId, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChannelParticipant withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateChannelParticipant(this.identifier, value, this.channelId, this.date, this.actorId, this.userId, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChannelParticipant withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateChannelParticipant(this.identifier, this.flags, value, this.date, this.actorId, this.userId, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChannelParticipant withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableUpdateChannelParticipant(this.identifier, this.flags, this.channelId, value, this.actorId, this.userId, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChannelParticipant withActorId(long value) {
        if (this.actorId == value) {
            return this;
        }
        return new ImmutableUpdateChannelParticipant(this.identifier, this.flags, this.channelId, this.date, value, this.userId, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChannelParticipant withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateChannelParticipant(this.identifier, this.flags, this.channelId, this.date, this.actorId, value, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChannelParticipant withPrevParticipant(@Nullable ChannelParticipant value) {
        if (this.prevParticipant == value) {
            return this;
        }
        return new ImmutableUpdateChannelParticipant(this.identifier, this.flags, this.channelId, this.date, this.actorId, this.userId, value, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChannelParticipant withNewParticipant(@Nullable ChannelParticipant value) {
        if (this.newParticipant == value) {
            return this;
        }
        return new ImmutableUpdateChannelParticipant(this.identifier, this.flags, this.channelId, this.date, this.actorId, this.userId, this.prevParticipant, value, this.invite, this.qts);
    }

    public final ImmutableUpdateChannelParticipant withInvite(@Nullable ExportedChatInvite value) {
        if (this.invite == value) {
            return this;
        }
        return new ImmutableUpdateChannelParticipant(this.identifier, this.flags, this.channelId, this.date, this.actorId, this.userId, this.prevParticipant, this.newParticipant, value, this.qts);
    }

    public final ImmutableUpdateChannelParticipant withQts(int value) {
        if (this.qts == value) {
            return this;
        }
        return new ImmutableUpdateChannelParticipant(this.identifier, this.flags, this.channelId, this.date, this.actorId, this.userId, this.prevParticipant, this.newParticipant, this.invite, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChannelParticipant && this.equalTo(0, (ImmutableUpdateChannelParticipant)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChannelParticipant another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.channelId == another.channelId && this.date == another.date && this.actorId == another.actorId && this.userId == another.userId && Objects.equals(this.prevParticipant, another.prevParticipant) && Objects.equals(this.newParticipant, another.newParticipant) && Objects.equals(this.invite, another.invite) && this.qts == another.qts;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + this.date;
        h += (h << 5) + Long.hashCode(this.actorId);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + Objects.hashCode(this.prevParticipant);
        h += (h << 5) + Objects.hashCode(this.newParticipant);
        h += (h << 5) + Objects.hashCode(this.invite);
        h += (h << 5) + this.qts;
        return h;
    }

    public String toString() {
        return "UpdateChannelParticipant{identifier=" + this.identifier + ", flags=" + this.flags + ", channelId=" + this.channelId + ", date=" + this.date + ", actorId=" + this.actorId + ", userId=" + this.userId + ", prevParticipant=" + this.prevParticipant + ", newParticipant=" + this.newParticipant + ", invite=" + this.invite + ", qts=" + this.qts + "}";
    }

    public static ImmutableUpdateChannelParticipant of(long channelId, int date, long actorId, long userId, int qts) {
        return new ImmutableUpdateChannelParticipant(channelId, date, actorId, userId, qts);
    }

    public static ImmutableUpdateChannelParticipant copyOf(UpdateChannelParticipant instance) {
        if (instance instanceof ImmutableUpdateChannelParticipant) {
            return (ImmutableUpdateChannelParticipant)instance;
        }
        return ImmutableUpdateChannelParticipant.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long INIT_BIT_ACTOR_ID = 4L;
        private static final long INIT_BIT_USER_ID = 8L;
        private static final long INIT_BIT_QTS = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private int flags;
        private long channelId;
        private int date;
        private long actorId;
        private long userId;
        private ChannelParticipant prevParticipant;
        private ChannelParticipant newParticipant;
        private ExportedChatInvite invite;
        private int qts;

        private Builder() {
        }

        public final Builder from(QtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateChannelParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof QtsUpdate) {
                instance = (QtsUpdate)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.qts(instance.qts());
                    bits |= 2L;
                }
            }
            if (object instanceof UpdateChannelParticipant) {
                ExportedChatInvite inviteValue;
                instance = (UpdateChannelParticipant)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.qts(instance.qts());
                    bits |= 2L;
                }
                this.actorId(instance.actorId());
                this.flags(instance.flags());
                ChannelParticipant newParticipantValue = instance.newParticipant();
                if (newParticipantValue != null) {
                    this.newParticipant(newParticipantValue);
                }
                if ((inviteValue = instance.invite()) != null) {
                    this.invite(inviteValue);
                }
                this.userId(instance.userId());
                ChannelParticipant prevParticipantValue = instance.prevParticipant();
                if (prevParticipantValue != null) {
                    this.prevParticipant(prevParticipantValue);
                }
                this.channelId(instance.channelId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder actorId(long actorId) {
            this.actorId = actorId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder prevParticipant(@Nullable ChannelParticipant prevParticipant) {
            this.prevParticipant = prevParticipant;
            return this;
        }

        public final Builder newParticipant(@Nullable ChannelParticipant newParticipant) {
            this.newParticipant = newParticipant;
            return this;
        }

        public final Builder invite(@Nullable ExportedChatInvite invite) {
            this.invite = invite;
            return this;
        }

        public final Builder qts(int qts) {
            this.qts = qts;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableUpdateChannelParticipant build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChannelParticipant(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("actorId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("qts");
            }
            return "Cannot build UpdateChannelParticipant, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateChannelParticipant.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateChannelParticipant.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateChannelParticipant, attribute initializers form cycle " + attributes;
        }
    }
}

