/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChannelTooLong;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChannelTooLong
implements UpdateChannelTooLong {
    private final int identifier;
    private final int flags;
    private final long channelId;
    @Nullable
    private final Integer pts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateChannelTooLong(long channelId) {
        this.channelId = channelId;
        this.pts = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateChannelTooLong(Builder builder) {
        this.channelId = builder.channelId;
        this.pts = builder.pts;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateChannelTooLong(int identifier, int flags, long channelId, @Nullable Integer pts) {
        this.identifier = identifier;
        this.flags = flags;
        this.channelId = channelId;
        this.pts = pts;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateChannelTooLong.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateChannelTooLong.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    @Nullable
    public Integer pts() {
        return this.pts;
    }

    public final ImmutableUpdateChannelTooLong withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChannelTooLong(value, this.flags, this.channelId, this.pts);
    }

    public final ImmutableUpdateChannelTooLong withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateChannelTooLong(this.identifier, value, this.channelId, this.pts);
    }

    public final ImmutableUpdateChannelTooLong withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateChannelTooLong(this.identifier, this.flags, value, this.pts);
    }

    public final ImmutableUpdateChannelTooLong withPts(@Nullable Integer value) {
        if (Objects.equals(this.pts, value)) {
            return this;
        }
        return new ImmutableUpdateChannelTooLong(this.identifier, this.flags, this.channelId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChannelTooLong && this.equalTo(0, (ImmutableUpdateChannelTooLong)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChannelTooLong another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.channelId == another.channelId && Objects.equals(this.pts, another.pts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + Objects.hashCode(this.pts);
        return h;
    }

    public String toString() {
        return "UpdateChannelTooLong{identifier=" + this.identifier + ", flags=" + this.flags + ", channelId=" + this.channelId + ", pts=" + this.pts + "}";
    }

    public static ImmutableUpdateChannelTooLong of(long channelId) {
        return new ImmutableUpdateChannelTooLong(channelId);
    }

    public static ImmutableUpdateChannelTooLong copyOf(UpdateChannelTooLong instance) {
        if (instance instanceof ImmutableUpdateChannelTooLong) {
            return (ImmutableUpdateChannelTooLong)instance;
        }
        return ImmutableUpdateChannelTooLong.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private long channelId;
        private Integer pts;

        private Builder() {
        }

        public final Builder from(UpdateChannelTooLong instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChannelTooLong) {
                instance = (UpdateChannelTooLong)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.channelId(instance.channelId());
                Integer ptsValue = instance.pts();
                if (ptsValue != null) {
                    this.pts(ptsValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder pts(@Nullable Integer pts) {
            this.pts = pts;
            return this;
        }

        public ImmutableUpdateChannelTooLong build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChannelTooLong(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            return "Cannot build UpdateChannelTooLong, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateChannelTooLong.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateChannelTooLong.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateChannelTooLong, attribute initializers form cycle " + attributes;
        }
    }
}

