/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Peer;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChannelUserTyping;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChannelUserTyping
implements UpdateChannelUserTyping {
    private final int identifier;
    private final int flags;
    private final long channelId;
    @Nullable
    private final Integer topMsgId;
    private final Peer fromId;
    private final SendMessageAction action;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateChannelUserTyping(long channelId, Peer fromId, SendMessageAction action) {
        this.channelId = channelId;
        this.fromId = Objects.requireNonNull(fromId, "fromId");
        this.action = Objects.requireNonNull(action, "action");
        this.topMsgId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateChannelUserTyping(Builder builder) {
        this.channelId = builder.channelId;
        this.topMsgId = builder.topMsgId;
        this.fromId = builder.fromId;
        this.action = builder.action;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateChannelUserTyping(int identifier, int flags, long channelId, @Nullable Integer topMsgId, Peer fromId, SendMessageAction action) {
        this.identifier = identifier;
        this.flags = flags;
        this.channelId = channelId;
        this.topMsgId = topMsgId;
        this.fromId = fromId;
        this.action = action;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateChannelUserTyping.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateChannelUserTyping.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    @Nullable
    public Integer topMsgId() {
        return this.topMsgId;
    }

    @Override
    public Peer fromId() {
        return this.fromId;
    }

    @Override
    public SendMessageAction action() {
        return this.action;
    }

    public final ImmutableUpdateChannelUserTyping withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChannelUserTyping(value, this.flags, this.channelId, this.topMsgId, this.fromId, this.action);
    }

    public final ImmutableUpdateChannelUserTyping withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateChannelUserTyping(this.identifier, value, this.channelId, this.topMsgId, this.fromId, this.action);
    }

    public final ImmutableUpdateChannelUserTyping withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateChannelUserTyping(this.identifier, this.flags, value, this.topMsgId, this.fromId, this.action);
    }

    public final ImmutableUpdateChannelUserTyping withTopMsgId(@Nullable Integer value) {
        if (Objects.equals(this.topMsgId, value)) {
            return this;
        }
        return new ImmutableUpdateChannelUserTyping(this.identifier, this.flags, this.channelId, value, this.fromId, this.action);
    }

    public final ImmutableUpdateChannelUserTyping withFromId(Peer value) {
        if (this.fromId == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "fromId");
        return new ImmutableUpdateChannelUserTyping(this.identifier, this.flags, this.channelId, this.topMsgId, newValue, this.action);
    }

    public final ImmutableUpdateChannelUserTyping withAction(SendMessageAction value) {
        if (this.action == value) {
            return this;
        }
        SendMessageAction newValue = Objects.requireNonNull(value, "action");
        return new ImmutableUpdateChannelUserTyping(this.identifier, this.flags, this.channelId, this.topMsgId, this.fromId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChannelUserTyping && this.equalTo(0, (ImmutableUpdateChannelUserTyping)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChannelUserTyping another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.channelId == another.channelId && Objects.equals(this.topMsgId, another.topMsgId) && this.fromId.equals(another.fromId) && this.action.equals(another.action);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + Objects.hashCode(this.topMsgId);
        h += (h << 5) + this.fromId.hashCode();
        h += (h << 5) + this.action.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateChannelUserTyping{identifier=" + this.identifier + ", flags=" + this.flags + ", channelId=" + this.channelId + ", topMsgId=" + this.topMsgId + ", fromId=" + this.fromId + ", action=" + this.action + "}";
    }

    public static ImmutableUpdateChannelUserTyping of(long channelId, Peer fromId, SendMessageAction action) {
        return new ImmutableUpdateChannelUserTyping(channelId, fromId, action);
    }

    public static ImmutableUpdateChannelUserTyping copyOf(UpdateChannelUserTyping instance) {
        if (instance instanceof ImmutableUpdateChannelUserTyping) {
            return (ImmutableUpdateChannelUserTyping)instance;
        }
        return ImmutableUpdateChannelUserTyping.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_FROM_ID = 2L;
        private static final long INIT_BIT_ACTION = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private long channelId;
        private Integer topMsgId;
        private Peer fromId;
        private SendMessageAction action;

        private Builder() {
        }

        public final Builder from(UpdateChannelUserTyping instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChannelUserTyping) {
                instance = (UpdateChannelUserTyping)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.action(instance.action());
                Integer topMsgIdValue = instance.topMsgId();
                if (topMsgIdValue != null) {
                    this.topMsgId(topMsgIdValue);
                }
                this.fromId(instance.fromId());
                this.channelId(instance.channelId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder topMsgId(@Nullable Integer topMsgId) {
            this.topMsgId = topMsgId;
            return this;
        }

        public final Builder fromId(Peer fromId) {
            this.fromId = Objects.requireNonNull(fromId, "fromId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder action(SendMessageAction action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateChannelUserTyping build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChannelUserTyping(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fromId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("action");
            }
            return "Cannot build UpdateChannelUserTyping, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateChannelUserTyping.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateChannelUserTyping.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateChannelUserTyping, attribute initializers form cycle " + attributes;
        }
    }
}

