/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChannelWebPage;
import telegram4j.tl.WebPage;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChannelWebPage
implements UpdateChannelWebPage {
    private final int identifier;
    private final long channelId;
    private final WebPage webpage;
    private final int pts;
    private final int ptsCount;

    private ImmutableUpdateChannelWebPage(long channelId, WebPage webpage, int pts, int ptsCount) {
        this.channelId = channelId;
        this.webpage = Objects.requireNonNull(webpage, "webpage");
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.identifier = UpdateChannelWebPage.super.identifier();
    }

    private ImmutableUpdateChannelWebPage(Builder builder) {
        this.channelId = builder.channelId;
        this.webpage = builder.webpage;
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChannelWebPage.super.identifier();
    }

    private ImmutableUpdateChannelWebPage(int identifier, long channelId, WebPage webpage, int pts, int ptsCount) {
        this.identifier = identifier;
        this.channelId = channelId;
        this.webpage = webpage;
        this.pts = pts;
        this.ptsCount = ptsCount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public WebPage webpage() {
        return this.webpage;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    public final ImmutableUpdateChannelWebPage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChannelWebPage(value, this.channelId, this.webpage, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateChannelWebPage withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateChannelWebPage(this.identifier, value, this.webpage, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateChannelWebPage withWebpage(WebPage value) {
        if (this.webpage == value) {
            return this;
        }
        WebPage newValue = Objects.requireNonNull(value, "webpage");
        return new ImmutableUpdateChannelWebPage(this.identifier, this.channelId, newValue, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateChannelWebPage withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdateChannelWebPage(this.identifier, this.channelId, this.webpage, value, this.ptsCount);
    }

    public final ImmutableUpdateChannelWebPage withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableUpdateChannelWebPage(this.identifier, this.channelId, this.webpage, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChannelWebPage && this.equalTo(0, (ImmutableUpdateChannelWebPage)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChannelWebPage another) {
        return this.identifier == another.identifier && this.channelId == another.channelId && this.webpage.equals(another.webpage) && this.pts == another.pts && this.ptsCount == another.ptsCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + this.webpage.hashCode();
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        return h;
    }

    public String toString() {
        return "UpdateChannelWebPage{identifier=" + this.identifier + ", channelId=" + this.channelId + ", webpage=" + this.webpage + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + "}";
    }

    public static ImmutableUpdateChannelWebPage of(long channelId, WebPage webpage, int pts, int ptsCount) {
        return new ImmutableUpdateChannelWebPage(channelId, webpage, pts, ptsCount);
    }

    public static ImmutableUpdateChannelWebPage copyOf(UpdateChannelWebPage instance) {
        if (instance instanceof ImmutableUpdateChannelWebPage) {
            return (ImmutableUpdateChannelWebPage)instance;
        }
        return ImmutableUpdateChannelWebPage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_WEBPAGE = 2L;
        private static final long INIT_BIT_PTS = 4L;
        private static final long INIT_BIT_PTS_COUNT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long channelId;
        private WebPage webpage;
        private int pts;
        private int ptsCount;

        private Builder() {
        }

        public final Builder from(UpdateChannelWebPage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChannelWebPage) {
                instance = (UpdateChannelWebPage)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.webpage(instance.webpage());
                this.channelId(instance.channelId());
                if ((bits & 4L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PtsUpdate) {
                instance = (PtsUpdate)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 4L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder webpage(WebPage webpage) {
            this.webpage = Objects.requireNonNull(webpage, "webpage");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUpdateChannelWebPage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChannelWebPage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("webpage");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ptsCount");
            }
            return "Cannot build UpdateChannelWebPage, some of required attributes are not set " + attributes;
        }
    }
}

