/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChat;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChat
implements UpdateChat {
    private final int identifier;
    private final long chatId;

    private ImmutableUpdateChat(long chatId) {
        this.chatId = chatId;
        this.identifier = UpdateChat.super.identifier();
    }

    private ImmutableUpdateChat(Builder builder) {
        this.chatId = builder.chatId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChat.super.identifier();
    }

    private ImmutableUpdateChat(int identifier, long chatId) {
        this.identifier = identifier;
        this.chatId = chatId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    public final ImmutableUpdateChat withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChat(value, this.chatId);
    }

    public final ImmutableUpdateChat withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableUpdateChat(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChat && this.equalTo(0, (ImmutableUpdateChat)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChat another) {
        return this.identifier == another.identifier && this.chatId == another.chatId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        return h;
    }

    public String toString() {
        return "UpdateChat{identifier=" + this.identifier + ", chatId=" + this.chatId + "}";
    }

    public static ImmutableUpdateChat of(long chatId) {
        return new ImmutableUpdateChat(chatId);
    }

    public static ImmutableUpdateChat copyOf(UpdateChat instance) {
        if (instance instanceof ImmutableUpdateChat) {
            return (ImmutableUpdateChat)instance;
        }
        return ImmutableUpdateChat.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long chatId;

        private Builder() {
        }

        public final Builder from(UpdateChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChat) {
                instance = (UpdateChat)object;
                this.chatId(instance.chatId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateChat build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChat(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            return "Cannot build UpdateChat, some of required attributes are not set " + attributes;
        }
    }
}

