/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChatBannedRights;
import telegram4j.tl.Peer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChatDefaultBannedRights;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChatDefaultBannedRights
implements UpdateChatDefaultBannedRights {
    private final int identifier;
    private final Peer peer;
    private final ChatBannedRights defaultBannedRights;
    private final int version;

    private ImmutableUpdateChatDefaultBannedRights(Peer peer, ChatBannedRights defaultBannedRights, int version) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.defaultBannedRights = Objects.requireNonNull(defaultBannedRights, "defaultBannedRights");
        this.version = version;
        this.identifier = UpdateChatDefaultBannedRights.super.identifier();
    }

    private ImmutableUpdateChatDefaultBannedRights(Builder builder) {
        this.peer = builder.peer;
        this.defaultBannedRights = builder.defaultBannedRights;
        this.version = builder.version;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChatDefaultBannedRights.super.identifier();
    }

    private ImmutableUpdateChatDefaultBannedRights(int identifier, Peer peer, ChatBannedRights defaultBannedRights, int version) {
        this.identifier = identifier;
        this.peer = peer;
        this.defaultBannedRights = defaultBannedRights;
        this.version = version;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public ChatBannedRights defaultBannedRights() {
        return this.defaultBannedRights;
    }

    @Override
    public int version() {
        return this.version;
    }

    public final ImmutableUpdateChatDefaultBannedRights withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChatDefaultBannedRights(value, this.peer, this.defaultBannedRights, this.version);
    }

    public final ImmutableUpdateChatDefaultBannedRights withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateChatDefaultBannedRights(this.identifier, newValue, this.defaultBannedRights, this.version);
    }

    public final ImmutableUpdateChatDefaultBannedRights withDefaultBannedRights(ChatBannedRights value) {
        if (this.defaultBannedRights == value) {
            return this;
        }
        ChatBannedRights newValue = Objects.requireNonNull(value, "defaultBannedRights");
        return new ImmutableUpdateChatDefaultBannedRights(this.identifier, this.peer, newValue, this.version);
    }

    public final ImmutableUpdateChatDefaultBannedRights withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableUpdateChatDefaultBannedRights(this.identifier, this.peer, this.defaultBannedRights, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChatDefaultBannedRights && this.equalTo(0, (ImmutableUpdateChatDefaultBannedRights)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChatDefaultBannedRights another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.defaultBannedRights.equals(another.defaultBannedRights) && this.version == another.version;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.defaultBannedRights.hashCode();
        h += (h << 5) + this.version;
        return h;
    }

    public String toString() {
        return "UpdateChatDefaultBannedRights{identifier=" + this.identifier + ", peer=" + this.peer + ", defaultBannedRights=" + this.defaultBannedRights + ", version=" + this.version + "}";
    }

    public static ImmutableUpdateChatDefaultBannedRights of(Peer peer, ChatBannedRights defaultBannedRights, int version) {
        return new ImmutableUpdateChatDefaultBannedRights(peer, defaultBannedRights, version);
    }

    public static ImmutableUpdateChatDefaultBannedRights copyOf(UpdateChatDefaultBannedRights instance) {
        if (instance instanceof ImmutableUpdateChatDefaultBannedRights) {
            return (ImmutableUpdateChatDefaultBannedRights)instance;
        }
        return ImmutableUpdateChatDefaultBannedRights.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_DEFAULT_BANNED_RIGHTS = 2L;
        private static final long INIT_BIT_VERSION = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private ChatBannedRights defaultBannedRights;
        private int version;

        private Builder() {
        }

        public final Builder from(UpdateChatDefaultBannedRights instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChatDefaultBannedRights) {
                instance = (UpdateChatDefaultBannedRights)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.defaultBannedRights(instance.defaultBannedRights());
                this.version(instance.version());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder defaultBannedRights(ChatBannedRights defaultBannedRights) {
            this.defaultBannedRights = Objects.requireNonNull(defaultBannedRights, "defaultBannedRights");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateChatDefaultBannedRights build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChatDefaultBannedRights(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("defaultBannedRights");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build UpdateChatDefaultBannedRights, some of required attributes are not set " + attributes;
        }
    }
}

