/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChatParticipant;
import telegram4j.tl.ExportedChatInvite;
import telegram4j.tl.QtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChatParticipant;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChatParticipant
implements UpdateChatParticipant {
    private final int identifier;
    private final int flags;
    private final long chatId;
    private final int date;
    private final long actorId;
    private final long userId;
    @Nullable
    private final ChatParticipant prevParticipant;
    @Nullable
    private final ChatParticipant newParticipant;
    @Nullable
    private final ExportedChatInvite invite;
    private final int qts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateChatParticipant(long chatId, int date, long actorId, long userId, int qts) {
        this.chatId = chatId;
        this.date = date;
        this.actorId = actorId;
        this.userId = userId;
        this.qts = qts;
        this.prevParticipant = null;
        this.newParticipant = null;
        this.invite = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateChatParticipant(Builder builder) {
        this.chatId = builder.chatId;
        this.date = builder.date;
        this.actorId = builder.actorId;
        this.userId = builder.userId;
        this.prevParticipant = builder.prevParticipant;
        this.newParticipant = builder.newParticipant;
        this.invite = builder.invite;
        this.qts = builder.qts;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateChatParticipant(int identifier, int flags, long chatId, int date, long actorId, long userId, @Nullable ChatParticipant prevParticipant, @Nullable ChatParticipant newParticipant, @Nullable ExportedChatInvite invite, int qts) {
        this.identifier = identifier;
        this.flags = flags;
        this.chatId = chatId;
        this.date = date;
        this.actorId = actorId;
        this.userId = userId;
        this.prevParticipant = prevParticipant;
        this.newParticipant = newParticipant;
        this.invite = invite;
        this.qts = qts;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateChatParticipant.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateChatParticipant.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public long actorId() {
        return this.actorId;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    @Nullable
    public ChatParticipant prevParticipant() {
        return this.prevParticipant;
    }

    @Override
    @Nullable
    public ChatParticipant newParticipant() {
        return this.newParticipant;
    }

    @Override
    @Nullable
    public ExportedChatInvite invite() {
        return this.invite;
    }

    @Override
    public int qts() {
        return this.qts;
    }

    public final ImmutableUpdateChatParticipant withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipant(value, this.flags, this.chatId, this.date, this.actorId, this.userId, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChatParticipant withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipant(this.identifier, value, this.chatId, this.date, this.actorId, this.userId, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChatParticipant withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipant(this.identifier, this.flags, value, this.date, this.actorId, this.userId, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChatParticipant withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipant(this.identifier, this.flags, this.chatId, value, this.actorId, this.userId, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChatParticipant withActorId(long value) {
        if (this.actorId == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipant(this.identifier, this.flags, this.chatId, this.date, value, this.userId, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChatParticipant withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipant(this.identifier, this.flags, this.chatId, this.date, this.actorId, value, this.prevParticipant, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChatParticipant withPrevParticipant(@Nullable ChatParticipant value) {
        if (this.prevParticipant == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipant(this.identifier, this.flags, this.chatId, this.date, this.actorId, this.userId, value, this.newParticipant, this.invite, this.qts);
    }

    public final ImmutableUpdateChatParticipant withNewParticipant(@Nullable ChatParticipant value) {
        if (this.newParticipant == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipant(this.identifier, this.flags, this.chatId, this.date, this.actorId, this.userId, this.prevParticipant, value, this.invite, this.qts);
    }

    public final ImmutableUpdateChatParticipant withInvite(@Nullable ExportedChatInvite value) {
        if (this.invite == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipant(this.identifier, this.flags, this.chatId, this.date, this.actorId, this.userId, this.prevParticipant, this.newParticipant, value, this.qts);
    }

    public final ImmutableUpdateChatParticipant withQts(int value) {
        if (this.qts == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipant(this.identifier, this.flags, this.chatId, this.date, this.actorId, this.userId, this.prevParticipant, this.newParticipant, this.invite, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChatParticipant && this.equalTo(0, (ImmutableUpdateChatParticipant)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChatParticipant another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.chatId == another.chatId && this.date == another.date && this.actorId == another.actorId && this.userId == another.userId && Objects.equals(this.prevParticipant, another.prevParticipant) && Objects.equals(this.newParticipant, another.newParticipant) && Objects.equals(this.invite, another.invite) && this.qts == another.qts;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + this.date;
        h += (h << 5) + Long.hashCode(this.actorId);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + Objects.hashCode(this.prevParticipant);
        h += (h << 5) + Objects.hashCode(this.newParticipant);
        h += (h << 5) + Objects.hashCode(this.invite);
        h += (h << 5) + this.qts;
        return h;
    }

    public String toString() {
        return "UpdateChatParticipant{identifier=" + this.identifier + ", flags=" + this.flags + ", chatId=" + this.chatId + ", date=" + this.date + ", actorId=" + this.actorId + ", userId=" + this.userId + ", prevParticipant=" + this.prevParticipant + ", newParticipant=" + this.newParticipant + ", invite=" + this.invite + ", qts=" + this.qts + "}";
    }

    public static ImmutableUpdateChatParticipant of(long chatId, int date, long actorId, long userId, int qts) {
        return new ImmutableUpdateChatParticipant(chatId, date, actorId, userId, qts);
    }

    public static ImmutableUpdateChatParticipant copyOf(UpdateChatParticipant instance) {
        if (instance instanceof ImmutableUpdateChatParticipant) {
            return (ImmutableUpdateChatParticipant)instance;
        }
        return ImmutableUpdateChatParticipant.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long INIT_BIT_ACTOR_ID = 4L;
        private static final long INIT_BIT_USER_ID = 8L;
        private static final long INIT_BIT_QTS = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private int flags;
        private long chatId;
        private int date;
        private long actorId;
        private long userId;
        private ChatParticipant prevParticipant;
        private ChatParticipant newParticipant;
        private ExportedChatInvite invite;
        private int qts;

        private Builder() {
        }

        public final Builder from(QtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateChatParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof QtsUpdate) {
                instance = (QtsUpdate)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.qts(instance.qts());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateChatParticipant) {
                ExportedChatInvite inviteValue;
                instance = (UpdateChatParticipant)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.qts(instance.qts());
                    bits |= 2L;
                }
                this.actorId(instance.actorId());
                this.chatId(instance.chatId());
                this.flags(instance.flags());
                ChatParticipant newParticipantValue = instance.newParticipant();
                if (newParticipantValue != null) {
                    this.newParticipant(newParticipantValue);
                }
                if ((inviteValue = instance.invite()) != null) {
                    this.invite(inviteValue);
                }
                this.userId(instance.userId());
                ChatParticipant prevParticipantValue = instance.prevParticipant();
                if (prevParticipantValue != null) {
                    this.prevParticipant(prevParticipantValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder actorId(long actorId) {
            this.actorId = actorId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder prevParticipant(@Nullable ChatParticipant prevParticipant) {
            this.prevParticipant = prevParticipant;
            return this;
        }

        public final Builder newParticipant(@Nullable ChatParticipant newParticipant) {
            this.newParticipant = newParticipant;
            return this;
        }

        public final Builder invite(@Nullable ExportedChatInvite invite) {
            this.invite = invite;
            return this;
        }

        public final Builder qts(int qts) {
            this.qts = qts;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableUpdateChatParticipant build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChatParticipant(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("actorId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("qts");
            }
            return "Cannot build UpdateChatParticipant, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateChatParticipant.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateChatParticipant.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateChatParticipant, attribute initializers form cycle " + attributes;
        }
    }
}

