/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChatParticipantAdd;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChatParticipantAdd
implements UpdateChatParticipantAdd {
    private final int identifier;
    private final long chatId;
    private final long userId;
    private final long inviterId;
    private final int date;
    private final int version;

    private ImmutableUpdateChatParticipantAdd(long chatId, long userId, long inviterId, int date, int version) {
        this.chatId = chatId;
        this.userId = userId;
        this.inviterId = inviterId;
        this.date = date;
        this.version = version;
        this.identifier = UpdateChatParticipantAdd.super.identifier();
    }

    private ImmutableUpdateChatParticipantAdd(Builder builder) {
        this.chatId = builder.chatId;
        this.userId = builder.userId;
        this.inviterId = builder.inviterId;
        this.date = builder.date;
        this.version = builder.version;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChatParticipantAdd.super.identifier();
    }

    private ImmutableUpdateChatParticipantAdd(int identifier, long chatId, long userId, long inviterId, int date, int version) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.userId = userId;
        this.inviterId = inviterId;
        this.date = date;
        this.version = version;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public long inviterId() {
        return this.inviterId;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public int version() {
        return this.version;
    }

    public final ImmutableUpdateChatParticipantAdd withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantAdd(value, this.chatId, this.userId, this.inviterId, this.date, this.version);
    }

    public final ImmutableUpdateChatParticipantAdd withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantAdd(this.identifier, value, this.userId, this.inviterId, this.date, this.version);
    }

    public final ImmutableUpdateChatParticipantAdd withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantAdd(this.identifier, this.chatId, value, this.inviterId, this.date, this.version);
    }

    public final ImmutableUpdateChatParticipantAdd withInviterId(long value) {
        if (this.inviterId == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantAdd(this.identifier, this.chatId, this.userId, value, this.date, this.version);
    }

    public final ImmutableUpdateChatParticipantAdd withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantAdd(this.identifier, this.chatId, this.userId, this.inviterId, value, this.version);
    }

    public final ImmutableUpdateChatParticipantAdd withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantAdd(this.identifier, this.chatId, this.userId, this.inviterId, this.date, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChatParticipantAdd && this.equalTo(0, (ImmutableUpdateChatParticipantAdd)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChatParticipantAdd another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.userId == another.userId && this.inviterId == another.inviterId && this.date == another.date && this.version == another.version;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + Long.hashCode(this.inviterId);
        h += (h << 5) + this.date;
        h += (h << 5) + this.version;
        return h;
    }

    public String toString() {
        return "UpdateChatParticipantAdd{identifier=" + this.identifier + ", chatId=" + this.chatId + ", userId=" + this.userId + ", inviterId=" + this.inviterId + ", date=" + this.date + ", version=" + this.version + "}";
    }

    public static ImmutableUpdateChatParticipantAdd of(long chatId, long userId, long inviterId, int date, int version) {
        return new ImmutableUpdateChatParticipantAdd(chatId, userId, inviterId, date, version);
    }

    public static ImmutableUpdateChatParticipantAdd copyOf(UpdateChatParticipantAdd instance) {
        if (instance instanceof ImmutableUpdateChatParticipantAdd) {
            return (ImmutableUpdateChatParticipantAdd)instance;
        }
        return ImmutableUpdateChatParticipantAdd.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_INVITER_ID = 4L;
        private static final long INIT_BIT_DATE = 8L;
        private static final long INIT_BIT_VERSION = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private long chatId;
        private long userId;
        private long inviterId;
        private int date;
        private int version;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateChatParticipantAdd instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateChatParticipantAdd) {
                instance = (UpdateChatParticipantAdd)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.chatId(instance.chatId());
                this.inviterId(instance.inviterId());
                this.userId(instance.userId());
                this.version(instance.version());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder inviterId(long inviterId) {
            this.inviterId = inviterId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableUpdateChatParticipantAdd build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChatParticipantAdd(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("inviterId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build UpdateChatParticipantAdd, some of required attributes are not set " + attributes;
        }
    }
}

