/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChatParticipantAdmin;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChatParticipantAdmin
implements UpdateChatParticipantAdmin {
    private final int identifier;
    private final long chatId;
    private final long userId;
    private final boolean isAdmin;
    private final int version;

    private ImmutableUpdateChatParticipantAdmin(long chatId, long userId, boolean isAdmin, int version) {
        this.chatId = chatId;
        this.userId = userId;
        this.isAdmin = isAdmin;
        this.version = version;
        this.identifier = UpdateChatParticipantAdmin.super.identifier();
    }

    private ImmutableUpdateChatParticipantAdmin(Builder builder) {
        this.chatId = builder.chatId;
        this.userId = builder.userId;
        this.isAdmin = builder.isAdmin;
        this.version = builder.version;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChatParticipantAdmin.super.identifier();
    }

    private ImmutableUpdateChatParticipantAdmin(int identifier, long chatId, long userId, boolean isAdmin, int version) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.userId = userId;
        this.isAdmin = isAdmin;
        this.version = version;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public boolean isAdmin() {
        return this.isAdmin;
    }

    @Override
    public int version() {
        return this.version;
    }

    public final ImmutableUpdateChatParticipantAdmin withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantAdmin(value, this.chatId, this.userId, this.isAdmin, this.version);
    }

    public final ImmutableUpdateChatParticipantAdmin withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantAdmin(this.identifier, value, this.userId, this.isAdmin, this.version);
    }

    public final ImmutableUpdateChatParticipantAdmin withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantAdmin(this.identifier, this.chatId, value, this.isAdmin, this.version);
    }

    public final ImmutableUpdateChatParticipantAdmin withIsAdmin(boolean value) {
        if (this.isAdmin == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantAdmin(this.identifier, this.chatId, this.userId, value, this.version);
    }

    public final ImmutableUpdateChatParticipantAdmin withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantAdmin(this.identifier, this.chatId, this.userId, this.isAdmin, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChatParticipantAdmin && this.equalTo(0, (ImmutableUpdateChatParticipantAdmin)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChatParticipantAdmin another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.userId == another.userId && this.isAdmin == another.isAdmin && this.version == another.version;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + Boolean.hashCode(this.isAdmin);
        h += (h << 5) + this.version;
        return h;
    }

    public String toString() {
        return "UpdateChatParticipantAdmin{identifier=" + this.identifier + ", chatId=" + this.chatId + ", userId=" + this.userId + ", isAdmin=" + this.isAdmin + ", version=" + this.version + "}";
    }

    public static ImmutableUpdateChatParticipantAdmin of(long chatId, long userId, boolean isAdmin, int version) {
        return new ImmutableUpdateChatParticipantAdmin(chatId, userId, isAdmin, version);
    }

    public static ImmutableUpdateChatParticipantAdmin copyOf(UpdateChatParticipantAdmin instance) {
        if (instance instanceof ImmutableUpdateChatParticipantAdmin) {
            return (ImmutableUpdateChatParticipantAdmin)instance;
        }
        return ImmutableUpdateChatParticipantAdmin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_IS_ADMIN = 4L;
        private static final long INIT_BIT_VERSION = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long chatId;
        private long userId;
        private boolean isAdmin;
        private int version;

        private Builder() {
        }

        public final Builder from(UpdateChatParticipantAdmin instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChatParticipantAdmin) {
                instance = (UpdateChatParticipantAdmin)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.isAdmin(instance.isAdmin());
                this.chatId(instance.chatId());
                this.userId(instance.userId());
                this.version(instance.version());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder isAdmin(boolean isAdmin) {
            this.isAdmin = isAdmin;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableUpdateChatParticipantAdmin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChatParticipantAdmin(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("isAdmin");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build UpdateChatParticipantAdmin, some of required attributes are not set " + attributes;
        }
    }
}

