/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChatParticipantDelete;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChatParticipantDelete
implements UpdateChatParticipantDelete {
    private final int identifier;
    private final long chatId;
    private final long userId;
    private final int version;

    private ImmutableUpdateChatParticipantDelete(long chatId, long userId, int version) {
        this.chatId = chatId;
        this.userId = userId;
        this.version = version;
        this.identifier = UpdateChatParticipantDelete.super.identifier();
    }

    private ImmutableUpdateChatParticipantDelete(Builder builder) {
        this.chatId = builder.chatId;
        this.userId = builder.userId;
        this.version = builder.version;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChatParticipantDelete.super.identifier();
    }

    private ImmutableUpdateChatParticipantDelete(int identifier, long chatId, long userId, int version) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.userId = userId;
        this.version = version;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public int version() {
        return this.version;
    }

    public final ImmutableUpdateChatParticipantDelete withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantDelete(value, this.chatId, this.userId, this.version);
    }

    public final ImmutableUpdateChatParticipantDelete withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantDelete(this.identifier, value, this.userId, this.version);
    }

    public final ImmutableUpdateChatParticipantDelete withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantDelete(this.identifier, this.chatId, value, this.version);
    }

    public final ImmutableUpdateChatParticipantDelete withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipantDelete(this.identifier, this.chatId, this.userId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChatParticipantDelete && this.equalTo(0, (ImmutableUpdateChatParticipantDelete)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChatParticipantDelete another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.userId == another.userId && this.version == another.version;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.version;
        return h;
    }

    public String toString() {
        return "UpdateChatParticipantDelete{identifier=" + this.identifier + ", chatId=" + this.chatId + ", userId=" + this.userId + ", version=" + this.version + "}";
    }

    public static ImmutableUpdateChatParticipantDelete of(long chatId, long userId, int version) {
        return new ImmutableUpdateChatParticipantDelete(chatId, userId, version);
    }

    public static ImmutableUpdateChatParticipantDelete copyOf(UpdateChatParticipantDelete instance) {
        if (instance instanceof ImmutableUpdateChatParticipantDelete) {
            return (ImmutableUpdateChatParticipantDelete)instance;
        }
        return ImmutableUpdateChatParticipantDelete.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_VERSION = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long chatId;
        private long userId;
        private int version;

        private Builder() {
        }

        public final Builder from(UpdateChatParticipantDelete instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChatParticipantDelete) {
                instance = (UpdateChatParticipantDelete)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.chatId(instance.chatId());
                this.userId(instance.userId());
                this.version(instance.version());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateChatParticipantDelete build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChatParticipantDelete(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build UpdateChatParticipantDelete, some of required attributes are not set " + attributes;
        }
    }
}

