/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChatParticipants;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChatParticipants;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChatParticipants
implements UpdateChatParticipants {
    private final int identifier;
    private final ChatParticipants participants;

    private ImmutableUpdateChatParticipants(ChatParticipants participants) {
        this.participants = Objects.requireNonNull(participants, "participants");
        this.identifier = UpdateChatParticipants.super.identifier();
    }

    private ImmutableUpdateChatParticipants(Builder builder) {
        this.participants = builder.participants;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChatParticipants.super.identifier();
    }

    private ImmutableUpdateChatParticipants(int identifier, ChatParticipants participants) {
        this.identifier = identifier;
        this.participants = participants;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public ChatParticipants participants() {
        return this.participants;
    }

    public final ImmutableUpdateChatParticipants withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChatParticipants(value, this.participants);
    }

    public final ImmutableUpdateChatParticipants withParticipants(ChatParticipants value) {
        if (this.participants == value) {
            return this;
        }
        ChatParticipants newValue = Objects.requireNonNull(value, "participants");
        return new ImmutableUpdateChatParticipants(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChatParticipants && this.equalTo(0, (ImmutableUpdateChatParticipants)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChatParticipants another) {
        return this.identifier == another.identifier && this.participants.equals(another.participants);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.participants.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateChatParticipants{identifier=" + this.identifier + ", participants=" + this.participants + "}";
    }

    public static ImmutableUpdateChatParticipants of(ChatParticipants participants) {
        return new ImmutableUpdateChatParticipants(participants);
    }

    public static ImmutableUpdateChatParticipants copyOf(UpdateChatParticipants instance) {
        if (instance instanceof ImmutableUpdateChatParticipants) {
            return (ImmutableUpdateChatParticipants)instance;
        }
        return ImmutableUpdateChatParticipants.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PARTICIPANTS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private ChatParticipants participants;

        private Builder() {
        }

        public final Builder from(UpdateChatParticipants instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateChatParticipants) {
                instance = (UpdateChatParticipants)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.participants(instance.participants());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder participants(ChatParticipants participants) {
            this.participants = Objects.requireNonNull(participants, "participants");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateChatParticipants build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChatParticipants(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("participants");
            }
            return "Cannot build UpdateChatParticipants, some of required attributes are not set " + attributes;
        }
    }
}

