/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Peer;
import telegram4j.tl.SendMessageAction;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateChatUserTyping;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateChatUserTyping
implements UpdateChatUserTyping {
    private final int identifier;
    private final long chatId;
    private final Peer fromId;
    private final SendMessageAction action;

    private ImmutableUpdateChatUserTyping(long chatId, Peer fromId, SendMessageAction action) {
        this.chatId = chatId;
        this.fromId = Objects.requireNonNull(fromId, "fromId");
        this.action = Objects.requireNonNull(action, "action");
        this.identifier = UpdateChatUserTyping.super.identifier();
    }

    private ImmutableUpdateChatUserTyping(Builder builder) {
        this.chatId = builder.chatId;
        this.fromId = builder.fromId;
        this.action = builder.action;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateChatUserTyping.super.identifier();
    }

    private ImmutableUpdateChatUserTyping(int identifier, long chatId, Peer fromId, SendMessageAction action) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.fromId = fromId;
        this.action = action;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public Peer fromId() {
        return this.fromId;
    }

    @Override
    public SendMessageAction action() {
        return this.action;
    }

    public final ImmutableUpdateChatUserTyping withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateChatUserTyping(value, this.chatId, this.fromId, this.action);
    }

    public final ImmutableUpdateChatUserTyping withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableUpdateChatUserTyping(this.identifier, value, this.fromId, this.action);
    }

    public final ImmutableUpdateChatUserTyping withFromId(Peer value) {
        if (this.fromId == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "fromId");
        return new ImmutableUpdateChatUserTyping(this.identifier, this.chatId, newValue, this.action);
    }

    public final ImmutableUpdateChatUserTyping withAction(SendMessageAction value) {
        if (this.action == value) {
            return this;
        }
        SendMessageAction newValue = Objects.requireNonNull(value, "action");
        return new ImmutableUpdateChatUserTyping(this.identifier, this.chatId, this.fromId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateChatUserTyping && this.equalTo(0, (ImmutableUpdateChatUserTyping)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateChatUserTyping another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.fromId.equals(another.fromId) && this.action.equals(another.action);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + this.fromId.hashCode();
        h += (h << 5) + this.action.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateChatUserTyping{identifier=" + this.identifier + ", chatId=" + this.chatId + ", fromId=" + this.fromId + ", action=" + this.action + "}";
    }

    public static ImmutableUpdateChatUserTyping of(long chatId, Peer fromId, SendMessageAction action) {
        return new ImmutableUpdateChatUserTyping(chatId, fromId, action);
    }

    public static ImmutableUpdateChatUserTyping copyOf(UpdateChatUserTyping instance) {
        if (instance instanceof ImmutableUpdateChatUserTyping) {
            return (ImmutableUpdateChatUserTyping)instance;
        }
        return ImmutableUpdateChatUserTyping.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_FROM_ID = 2L;
        private static final long INIT_BIT_ACTION = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long chatId;
        private Peer fromId;
        private SendMessageAction action;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateChatUserTyping instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateChatUserTyping) {
                instance = (UpdateChatUserTyping)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.action(instance.action());
                this.chatId(instance.chatId());
                this.fromId(instance.fromId());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fromId(Peer fromId) {
            this.fromId = Objects.requireNonNull(fromId, "fromId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder action(SendMessageAction action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateChatUserTyping build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateChatUserTyping(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fromId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("action");
            }
            return "Cannot build UpdateChatUserTyping, some of required attributes are not set " + attributes;
        }
    }
}

