/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateConfig;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateConfig
implements UpdateConfig {
    private final int identifier;
    private static final ImmutableUpdateConfig INSTANCE = ImmutableUpdateConfig.validate(new ImmutableUpdateConfig());

    private ImmutableUpdateConfig() {
        this.identifier = UpdateConfig.super.identifier();
    }

    private ImmutableUpdateConfig(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateConfig.super.identifier();
    }

    private ImmutableUpdateConfig(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableUpdateConfig withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUpdateConfig.validate(new ImmutableUpdateConfig(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateConfig && this.equalTo(0, (ImmutableUpdateConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateConfig another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "UpdateConfig{identifier=" + this.identifier + "}";
    }

    public static ImmutableUpdateConfig of() {
        return INSTANCE;
    }

    private static ImmutableUpdateConfig validate(ImmutableUpdateConfig instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUpdateConfig copyOf(UpdateConfig instance) {
        if (instance instanceof ImmutableUpdateConfig) {
            return (ImmutableUpdateConfig)instance;
        }
        return ImmutableUpdateConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(UpdateConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateConfig) {
                instance = (UpdateConfig)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableUpdateConfig build() {
            return ImmutableUpdateConfig.validate(new ImmutableUpdateConfig(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

