/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.DcOption;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateDcOptions;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateDcOptions
implements UpdateDcOptions {
    private final int identifier;
    private final List<DcOption> dcOptions;

    private ImmutableUpdateDcOptions(Builder builder) {
        this.dcOptions = ImmutableUpdateDcOptions.createUnmodifiableList(true, builder.dcOptions);
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateDcOptions.super.identifier();
    }

    private ImmutableUpdateDcOptions(int identifier, List<DcOption> dcOptions) {
        this.identifier = identifier;
        this.dcOptions = dcOptions;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<DcOption> dcOptions() {
        return this.dcOptions;
    }

    public final ImmutableUpdateDcOptions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateDcOptions(value, this.dcOptions);
    }

    public final ImmutableUpdateDcOptions withDcOptions(DcOption ... elements) {
        List<DcOption> newValue = ImmutableUpdateDcOptions.createUnmodifiableList(false, ImmutableUpdateDcOptions.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUpdateDcOptions(this.identifier, newValue);
    }

    public final ImmutableUpdateDcOptions withDcOptions(Iterable<? extends DcOption> elements) {
        if (this.dcOptions == elements) {
            return this;
        }
        List<DcOption> newValue = ImmutableUpdateDcOptions.createUnmodifiableList(false, ImmutableUpdateDcOptions.createSafeList(elements, true, false));
        return new ImmutableUpdateDcOptions(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateDcOptions && this.equalTo(0, (ImmutableUpdateDcOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateDcOptions another) {
        return this.identifier == another.identifier && this.dcOptions.equals(another.dcOptions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.dcOptions.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateDcOptions{identifier=" + this.identifier + ", dcOptions=" + this.dcOptions + "}";
    }

    public static ImmutableUpdateDcOptions copyOf(UpdateDcOptions instance) {
        if (instance instanceof ImmutableUpdateDcOptions) {
            return (ImmutableUpdateDcOptions)instance;
        }
        return ImmutableUpdateDcOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<DcOption> dcOptions = new ArrayList<DcOption>();

        private Builder() {
        }

        public final Builder from(UpdateDcOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateDcOptions) {
                instance = (UpdateDcOptions)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllDcOptions(instance.dcOptions());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addDcOption(DcOption element) {
            this.dcOptions.add(Objects.requireNonNull(element, "dcOptions element"));
            return this;
        }

        public final Builder addDcOptions(DcOption ... elements) {
            for (DcOption element : elements) {
                this.dcOptions.add(Objects.requireNonNull(element, "dcOptions element"));
            }
            return this;
        }

        public final Builder dcOptions(Iterable<? extends DcOption> elements) {
            this.dcOptions.clear();
            return this.addAllDcOptions(elements);
        }

        public final Builder addAllDcOptions(Iterable<? extends DcOption> elements) {
            for (DcOption dcOption : elements) {
                this.dcOptions.add(Objects.requireNonNull(dcOption, "dcOptions element"));
            }
            return this;
        }

        public ImmutableUpdateDcOptions build() {
            return new ImmutableUpdateDcOptions(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

