/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateDeleteChannelMessages;
import telegram4j.tl.UpdateDeleteMessagesFields;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateDeleteChannelMessages
implements UpdateDeleteChannelMessages {
    private final int identifier;
    private final long channelId;
    private final List<Integer> messages;
    private final int pts;
    private final int ptsCount;

    private ImmutableUpdateDeleteChannelMessages(long channelId, int pts, int ptsCount) {
        this.channelId = channelId;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.messages = Collections.emptyList();
        this.identifier = UpdateDeleteChannelMessages.super.identifier();
    }

    private ImmutableUpdateDeleteChannelMessages(Builder builder) {
        this.channelId = builder.channelId;
        this.messages = ImmutableUpdateDeleteChannelMessages.createUnmodifiableList(true, builder.messages);
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateDeleteChannelMessages.super.identifier();
    }

    private ImmutableUpdateDeleteChannelMessages(int identifier, long channelId, List<Integer> messages, int pts, int ptsCount) {
        this.identifier = identifier;
        this.channelId = channelId;
        this.messages = messages;
        this.pts = pts;
        this.ptsCount = ptsCount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long channelId() {
        return this.channelId;
    }

    @Override
    public List<Integer> messages() {
        return this.messages;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    public final ImmutableUpdateDeleteChannelMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateDeleteChannelMessages(value, this.channelId, this.messages, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateDeleteChannelMessages withChannelId(long value) {
        if (this.channelId == value) {
            return this;
        }
        return new ImmutableUpdateDeleteChannelMessages(this.identifier, value, this.messages, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateDeleteChannelMessages withMessages(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableUpdateDeleteChannelMessages.createUnmodifiableList(false, wrappedList);
        return new ImmutableUpdateDeleteChannelMessages(this.identifier, this.channelId, newValue, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateDeleteChannelMessages withMessages(Iterable<Integer> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableUpdateDeleteChannelMessages.createUnmodifiableList(false, ImmutableUpdateDeleteChannelMessages.createSafeList(elements, true, false));
        return new ImmutableUpdateDeleteChannelMessages(this.identifier, this.channelId, newValue, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateDeleteChannelMessages withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdateDeleteChannelMessages(this.identifier, this.channelId, this.messages, value, this.ptsCount);
    }

    public final ImmutableUpdateDeleteChannelMessages withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableUpdateDeleteChannelMessages(this.identifier, this.channelId, this.messages, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateDeleteChannelMessages && this.equalTo(0, (ImmutableUpdateDeleteChannelMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateDeleteChannelMessages another) {
        return this.identifier == another.identifier && this.channelId == another.channelId && this.messages.equals(another.messages) && this.pts == another.pts && this.ptsCount == another.ptsCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.channelId);
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        return h;
    }

    public String toString() {
        return "UpdateDeleteChannelMessages{identifier=" + this.identifier + ", channelId=" + this.channelId + ", messages=" + this.messages + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + "}";
    }

    public static ImmutableUpdateDeleteChannelMessages of(long channelId, int pts, int ptsCount) {
        return new ImmutableUpdateDeleteChannelMessages(channelId, pts, ptsCount);
    }

    public static ImmutableUpdateDeleteChannelMessages copyOf(UpdateDeleteChannelMessages instance) {
        if (instance instanceof ImmutableUpdateDeleteChannelMessages) {
            return (ImmutableUpdateDeleteChannelMessages)instance;
        }
        return ImmutableUpdateDeleteChannelMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_PTS = 2L;
        private static final long INIT_BIT_PTS_COUNT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long channelId;
        private List<Integer> messages = new ArrayList<Integer>();
        private int pts;
        private int ptsCount;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateDeleteChannelMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateDeleteMessagesFields instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateDeleteChannelMessages) {
                instance = (UpdateDeleteChannelMessages)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllMessages(instance.messages());
                    bits |= 4L;
                }
                this.channelId(instance.channelId());
                if ((bits & 8L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 8L;
                }
            }
            if (object instanceof UpdateDeleteMessagesFields) {
                instance = (UpdateDeleteMessagesFields)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllMessages(instance.messages());
                    bits |= 4L;
                }
            }
            if (object instanceof PtsUpdate) {
                instance = (PtsUpdate)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 8L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder channelId(long channelId) {
            this.channelId = channelId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addMessage(int element) {
            this.messages.add(element);
            return this;
        }

        public final Builder addMessages(int ... elements) {
            for (int element : elements) {
                this.messages.add(element);
            }
            return this;
        }

        public final Builder messages(Iterable<Integer> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateDeleteChannelMessages build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateDeleteChannelMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ptsCount");
            }
            return "Cannot build UpdateDeleteChannelMessages, some of required attributes are not set " + attributes;
        }
    }
}

