/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Peer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateDeleteMessagesFields;
import telegram4j.tl.UpdateDeleteScheduledMessages;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateDeleteScheduledMessages
implements UpdateDeleteScheduledMessages {
    private final int identifier;
    private final Peer peer;
    private final List<Integer> messages;

    private ImmutableUpdateDeleteScheduledMessages(Peer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.messages = Collections.emptyList();
        this.identifier = UpdateDeleteScheduledMessages.super.identifier();
    }

    private ImmutableUpdateDeleteScheduledMessages(Builder builder) {
        this.peer = builder.peer;
        this.messages = ImmutableUpdateDeleteScheduledMessages.createUnmodifiableList(true, builder.messages);
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateDeleteScheduledMessages.super.identifier();
    }

    private ImmutableUpdateDeleteScheduledMessages(int identifier, Peer peer, List<Integer> messages) {
        this.identifier = identifier;
        this.peer = peer;
        this.messages = messages;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public List<Integer> messages() {
        return this.messages;
    }

    public final ImmutableUpdateDeleteScheduledMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateDeleteScheduledMessages(value, this.peer, this.messages);
    }

    public final ImmutableUpdateDeleteScheduledMessages withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateDeleteScheduledMessages(this.identifier, newValue, this.messages);
    }

    public final ImmutableUpdateDeleteScheduledMessages withMessages(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableUpdateDeleteScheduledMessages.createUnmodifiableList(false, wrappedList);
        return new ImmutableUpdateDeleteScheduledMessages(this.identifier, this.peer, newValue);
    }

    public final ImmutableUpdateDeleteScheduledMessages withMessages(Iterable<Integer> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableUpdateDeleteScheduledMessages.createUnmodifiableList(false, ImmutableUpdateDeleteScheduledMessages.createSafeList(elements, true, false));
        return new ImmutableUpdateDeleteScheduledMessages(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateDeleteScheduledMessages && this.equalTo(0, (ImmutableUpdateDeleteScheduledMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateDeleteScheduledMessages another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateDeleteScheduledMessages{identifier=" + this.identifier + ", peer=" + this.peer + ", messages=" + this.messages + "}";
    }

    public static ImmutableUpdateDeleteScheduledMessages of(Peer peer) {
        return new ImmutableUpdateDeleteScheduledMessages(peer);
    }

    public static ImmutableUpdateDeleteScheduledMessages copyOf(UpdateDeleteScheduledMessages instance) {
        if (instance instanceof ImmutableUpdateDeleteScheduledMessages) {
            return (ImmutableUpdateDeleteScheduledMessages)instance;
        }
        return ImmutableUpdateDeleteScheduledMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private List<Integer> messages = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(UpdateDeleteScheduledMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateDeleteMessagesFields instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateDeleteScheduledMessages) {
                instance = (UpdateDeleteScheduledMessages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllMessages(instance.messages());
                    bits |= 2L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateDeleteMessagesFields) {
                instance = (UpdateDeleteMessagesFields)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllMessages(instance.messages());
                    bits |= 2L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addMessage(int element) {
            this.messages.add(element);
            return this;
        }

        public final Builder addMessages(int ... elements) {
            for (int element : elements) {
                this.messages.add(element);
            }
            return this;
        }

        public final Builder messages(Iterable<Integer> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public ImmutableUpdateDeleteScheduledMessages build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateDeleteScheduledMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build UpdateDeleteScheduledMessages, some of required attributes are not set " + attributes;
        }
    }
}

