/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateDialogFilterOrder;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateDialogFilterOrder
implements UpdateDialogFilterOrder {
    private final int identifier;
    private final List<Integer> order;

    private ImmutableUpdateDialogFilterOrder(Builder builder) {
        this.order = ImmutableUpdateDialogFilterOrder.createUnmodifiableList(true, builder.order);
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateDialogFilterOrder.super.identifier();
    }

    private ImmutableUpdateDialogFilterOrder(int identifier, List<Integer> order) {
        this.identifier = identifier;
        this.order = order;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Integer> order() {
        return this.order;
    }

    public final ImmutableUpdateDialogFilterOrder withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateDialogFilterOrder(value, this.order);
    }

    public final ImmutableUpdateDialogFilterOrder withOrder(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableUpdateDialogFilterOrder.createUnmodifiableList(false, wrappedList);
        return new ImmutableUpdateDialogFilterOrder(this.identifier, newValue);
    }

    public final ImmutableUpdateDialogFilterOrder withOrder(Iterable<Integer> elements) {
        if (this.order == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableUpdateDialogFilterOrder.createUnmodifiableList(false, ImmutableUpdateDialogFilterOrder.createSafeList(elements, true, false));
        return new ImmutableUpdateDialogFilterOrder(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateDialogFilterOrder && this.equalTo(0, (ImmutableUpdateDialogFilterOrder)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateDialogFilterOrder another) {
        return this.identifier == another.identifier && this.order.equals(another.order);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.order.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateDialogFilterOrder{identifier=" + this.identifier + ", order=" + this.order + "}";
    }

    public static ImmutableUpdateDialogFilterOrder copyOf(UpdateDialogFilterOrder instance) {
        if (instance instanceof ImmutableUpdateDialogFilterOrder) {
            return (ImmutableUpdateDialogFilterOrder)instance;
        }
        return ImmutableUpdateDialogFilterOrder.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Integer> order = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateDialogFilterOrder instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateDialogFilterOrder) {
                instance = (UpdateDialogFilterOrder)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllOrder(instance.order());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addOrder(int element) {
            this.order.add(element);
            return this;
        }

        public final Builder addOrder(int ... elements) {
            for (int element : elements) {
                this.order.add(element);
            }
            return this;
        }

        public final Builder order(Iterable<Integer> elements) {
            this.order.clear();
            return this.addAllOrder(elements);
        }

        public final Builder addAllOrder(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.order.add(Objects.requireNonNull(element, "order element"));
            }
            return this;
        }

        public ImmutableUpdateDialogFilterOrder build() {
            return new ImmutableUpdateDialogFilterOrder(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

