/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateDialogFilters;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateDialogFilters
implements UpdateDialogFilters {
    private final int identifier;
    private static final ImmutableUpdateDialogFilters INSTANCE = ImmutableUpdateDialogFilters.validate(new ImmutableUpdateDialogFilters());

    private ImmutableUpdateDialogFilters() {
        this.identifier = UpdateDialogFilters.super.identifier();
    }

    private ImmutableUpdateDialogFilters(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateDialogFilters.super.identifier();
    }

    private ImmutableUpdateDialogFilters(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableUpdateDialogFilters withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUpdateDialogFilters.validate(new ImmutableUpdateDialogFilters(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateDialogFilters && this.equalTo(0, (ImmutableUpdateDialogFilters)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateDialogFilters another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "UpdateDialogFilters{identifier=" + this.identifier + "}";
    }

    public static ImmutableUpdateDialogFilters of() {
        return INSTANCE;
    }

    private static ImmutableUpdateDialogFilters validate(ImmutableUpdateDialogFilters instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUpdateDialogFilters copyOf(UpdateDialogFilters instance) {
        if (instance instanceof ImmutableUpdateDialogFilters) {
            return (ImmutableUpdateDialogFilters)instance;
        }
        return ImmutableUpdateDialogFilters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(UpdateDialogFilters instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateDialogFilters) {
                instance = (UpdateDialogFilters)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableUpdateDialogFilters build() {
            return ImmutableUpdateDialogFilters.validate(new ImmutableUpdateDialogFilters(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

