/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DialogPeer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateDialogUnreadMark;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateDialogUnreadMark
implements UpdateDialogUnreadMark {
    private final int identifier;
    private final int flags;
    private final boolean unread;
    private final DialogPeer peer;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateDialogUnreadMark(DialogPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.unread = this.initShim.unread();
        this.initShim = null;
    }

    private ImmutableUpdateDialogUnreadMark(Builder builder) {
        this.peer = builder.peer;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.unreadIsSet()) {
            this.initShim.unread(builder.unread);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.unread = this.initShim.unread();
        this.initShim = null;
    }

    private ImmutableUpdateDialogUnreadMark(int identifier, int flags, boolean unread, DialogPeer peer) {
        this.identifier = identifier;
        this.flags = flags;
        this.unread = unread;
        this.peer = peer;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateDialogUnreadMark.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateDialogUnreadMark.super.flags();
    }

    private boolean unreadInitialize() {
        return UpdateDialogUnreadMark.super.unread();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean unread() {
        InitShim shim = this.initShim;
        return shim != null ? shim.unread() : this.unread;
    }

    @Override
    public DialogPeer peer() {
        return this.peer;
    }

    public final ImmutableUpdateDialogUnreadMark withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateDialogUnreadMark(value, this.flags, this.unread, this.peer);
    }

    public final ImmutableUpdateDialogUnreadMark withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateDialogUnreadMark(this.identifier, value, this.unread, this.peer);
    }

    public final ImmutableUpdateDialogUnreadMark withUnread(boolean value) {
        if (this.unread == value) {
            return this;
        }
        return new ImmutableUpdateDialogUnreadMark(this.identifier, this.flags, value, this.peer);
    }

    public final ImmutableUpdateDialogUnreadMark withPeer(DialogPeer value) {
        if (this.peer == value) {
            return this;
        }
        DialogPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateDialogUnreadMark(this.identifier, this.flags, this.unread, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateDialogUnreadMark && this.equalTo(0, (ImmutableUpdateDialogUnreadMark)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateDialogUnreadMark another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.unread == another.unread && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.unread);
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateDialogUnreadMark{identifier=" + this.identifier + ", flags=" + this.flags + ", unread=" + this.unread + ", peer=" + this.peer + "}";
    }

    public static ImmutableUpdateDialogUnreadMark of(DialogPeer peer) {
        return new ImmutableUpdateDialogUnreadMark(peer);
    }

    public static ImmutableUpdateDialogUnreadMark copyOf(UpdateDialogUnreadMark instance) {
        if (instance instanceof ImmutableUpdateDialogUnreadMark) {
            return (ImmutableUpdateDialogUnreadMark)instance;
        }
        return ImmutableUpdateDialogUnreadMark.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_UNREAD = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean unread;
        private DialogPeer peer;

        private Builder() {
        }

        public final Builder from(UpdateDialogUnreadMark instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateDialogUnreadMark) {
                instance = (UpdateDialogUnreadMark)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.unread(instance.unread());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder unread(boolean unread) {
            this.unread = unread;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(DialogPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateDialogUnreadMark build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateDialogUnreadMark(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean unreadIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build UpdateDialogUnreadMark, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte unreadBuildStage = 0;
        private boolean unread;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateDialogUnreadMark.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateDialogUnreadMark.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean unread() {
            if (this.unreadBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.unreadBuildStage == 0) {
                this.unreadBuildStage = (byte)-1;
                this.unread = ImmutableUpdateDialogUnreadMark.this.unreadInitialize();
                this.unreadBuildStage = 1;
            }
            return this.unread;
        }

        void unread(boolean unread) {
            this.unread = unread;
            this.unreadBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.unreadBuildStage == -1) {
                attributes.add("unread");
            }
            return "Cannot build UpdateDialogUnreadMark, attribute initializers form cycle " + attributes;
        }
    }
}

