/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DraftMessage;
import telegram4j.tl.Peer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateDraftMessage;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateDraftMessage
implements UpdateDraftMessage {
    private final int identifier;
    private final Peer peer;
    private final DraftMessage draft;

    private ImmutableUpdateDraftMessage(Peer peer, DraftMessage draft) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.draft = Objects.requireNonNull(draft, "draft");
        this.identifier = UpdateDraftMessage.super.identifier();
    }

    private ImmutableUpdateDraftMessage(Builder builder) {
        this.peer = builder.peer;
        this.draft = builder.draft;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateDraftMessage.super.identifier();
    }

    private ImmutableUpdateDraftMessage(int identifier, Peer peer, DraftMessage draft) {
        this.identifier = identifier;
        this.peer = peer;
        this.draft = draft;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public DraftMessage draft() {
        return this.draft;
    }

    public final ImmutableUpdateDraftMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateDraftMessage(value, this.peer, this.draft);
    }

    public final ImmutableUpdateDraftMessage withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateDraftMessage(this.identifier, newValue, this.draft);
    }

    public final ImmutableUpdateDraftMessage withDraft(DraftMessage value) {
        if (this.draft == value) {
            return this;
        }
        DraftMessage newValue = Objects.requireNonNull(value, "draft");
        return new ImmutableUpdateDraftMessage(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateDraftMessage && this.equalTo(0, (ImmutableUpdateDraftMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateDraftMessage another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.draft.equals(another.draft);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.draft.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateDraftMessage{identifier=" + this.identifier + ", peer=" + this.peer + ", draft=" + this.draft + "}";
    }

    public static ImmutableUpdateDraftMessage of(Peer peer, DraftMessage draft) {
        return new ImmutableUpdateDraftMessage(peer, draft);
    }

    public static ImmutableUpdateDraftMessage copyOf(UpdateDraftMessage instance) {
        if (instance instanceof ImmutableUpdateDraftMessage) {
            return (ImmutableUpdateDraftMessage)instance;
        }
        return ImmutableUpdateDraftMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_DRAFT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private DraftMessage draft;

        private Builder() {
        }

        public final Builder from(UpdateDraftMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateDraftMessage) {
                instance = (UpdateDraftMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.draft(instance.draft());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder draft(DraftMessage draft) {
            this.draft = Objects.requireNonNull(draft, "draft");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateDraftMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateDraftMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("draft");
            }
            return "Cannot build UpdateDraftMessage, some of required attributes are not set " + attributes;
        }
    }
}

