/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateEncryptedChatTyping;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateEncryptedChatTyping
implements UpdateEncryptedChatTyping {
    private final int identifier;
    private final int chatId;

    private ImmutableUpdateEncryptedChatTyping(int chatId) {
        this.chatId = chatId;
        this.identifier = UpdateEncryptedChatTyping.super.identifier();
    }

    private ImmutableUpdateEncryptedChatTyping(Builder builder) {
        this.chatId = builder.chatId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateEncryptedChatTyping.super.identifier();
    }

    private ImmutableUpdateEncryptedChatTyping(int identifier, int chatId) {
        this.identifier = identifier;
        this.chatId = chatId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int chatId() {
        return this.chatId;
    }

    public final ImmutableUpdateEncryptedChatTyping withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateEncryptedChatTyping(value, this.chatId);
    }

    public final ImmutableUpdateEncryptedChatTyping withChatId(int value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableUpdateEncryptedChatTyping(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateEncryptedChatTyping && this.equalTo(0, (ImmutableUpdateEncryptedChatTyping)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateEncryptedChatTyping another) {
        return this.identifier == another.identifier && this.chatId == another.chatId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.chatId;
        return h;
    }

    public String toString() {
        return "UpdateEncryptedChatTyping{identifier=" + this.identifier + ", chatId=" + this.chatId + "}";
    }

    public static ImmutableUpdateEncryptedChatTyping of(int chatId) {
        return new ImmutableUpdateEncryptedChatTyping(chatId);
    }

    public static ImmutableUpdateEncryptedChatTyping copyOf(UpdateEncryptedChatTyping instance) {
        if (instance instanceof ImmutableUpdateEncryptedChatTyping) {
            return (ImmutableUpdateEncryptedChatTyping)instance;
        }
        return ImmutableUpdateEncryptedChatTyping.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int chatId;

        private Builder() {
        }

        public final Builder from(UpdateEncryptedChatTyping instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateEncryptedChatTyping) {
                instance = (UpdateEncryptedChatTyping)object;
                this.chatId(instance.chatId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(int chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateEncryptedChatTyping build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateEncryptedChatTyping(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            return "Cannot build UpdateEncryptedChatTyping, some of required attributes are not set " + attributes;
        }
    }
}

