/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateEncryptedMessagesRead;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateEncryptedMessagesRead
implements UpdateEncryptedMessagesRead {
    private final int identifier;
    private final int chatId;
    private final int maxDate;
    private final int date;

    private ImmutableUpdateEncryptedMessagesRead(int chatId, int maxDate, int date) {
        this.chatId = chatId;
        this.maxDate = maxDate;
        this.date = date;
        this.identifier = UpdateEncryptedMessagesRead.super.identifier();
    }

    private ImmutableUpdateEncryptedMessagesRead(Builder builder) {
        this.chatId = builder.chatId;
        this.maxDate = builder.maxDate;
        this.date = builder.date;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateEncryptedMessagesRead.super.identifier();
    }

    private ImmutableUpdateEncryptedMessagesRead(int identifier, int chatId, int maxDate, int date) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.maxDate = maxDate;
        this.date = date;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int chatId() {
        return this.chatId;
    }

    @Override
    public int maxDate() {
        return this.maxDate;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableUpdateEncryptedMessagesRead withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateEncryptedMessagesRead(value, this.chatId, this.maxDate, this.date);
    }

    public final ImmutableUpdateEncryptedMessagesRead withChatId(int value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableUpdateEncryptedMessagesRead(this.identifier, value, this.maxDate, this.date);
    }

    public final ImmutableUpdateEncryptedMessagesRead withMaxDate(int value) {
        if (this.maxDate == value) {
            return this;
        }
        return new ImmutableUpdateEncryptedMessagesRead(this.identifier, this.chatId, value, this.date);
    }

    public final ImmutableUpdateEncryptedMessagesRead withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableUpdateEncryptedMessagesRead(this.identifier, this.chatId, this.maxDate, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateEncryptedMessagesRead && this.equalTo(0, (ImmutableUpdateEncryptedMessagesRead)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateEncryptedMessagesRead another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.maxDate == another.maxDate && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.chatId;
        h += (h << 5) + this.maxDate;
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "UpdateEncryptedMessagesRead{identifier=" + this.identifier + ", chatId=" + this.chatId + ", maxDate=" + this.maxDate + ", date=" + this.date + "}";
    }

    public static ImmutableUpdateEncryptedMessagesRead of(int chatId, int maxDate, int date) {
        return new ImmutableUpdateEncryptedMessagesRead(chatId, maxDate, date);
    }

    public static ImmutableUpdateEncryptedMessagesRead copyOf(UpdateEncryptedMessagesRead instance) {
        if (instance instanceof ImmutableUpdateEncryptedMessagesRead) {
            return (ImmutableUpdateEncryptedMessagesRead)instance;
        }
        return ImmutableUpdateEncryptedMessagesRead.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_MAX_DATE = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int chatId;
        private int maxDate;
        private int date;

        private Builder() {
        }

        public final Builder from(UpdateEncryptedMessagesRead instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateEncryptedMessagesRead) {
                instance = (UpdateEncryptedMessagesRead)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.maxDate(instance.maxDate());
                this.chatId(instance.chatId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(int chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder maxDate(int maxDate) {
            this.maxDate = maxDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateEncryptedMessagesRead build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateEncryptedMessagesRead(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxDate");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build UpdateEncryptedMessagesRead, some of required attributes are not set " + attributes;
        }
    }
}

