/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.EncryptedChat;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateEncryption;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateEncryption
implements UpdateEncryption {
    private final int identifier;
    private final EncryptedChat chat;
    private final int date;

    private ImmutableUpdateEncryption(EncryptedChat chat, int date) {
        this.chat = Objects.requireNonNull(chat, "chat");
        this.date = date;
        this.identifier = UpdateEncryption.super.identifier();
    }

    private ImmutableUpdateEncryption(Builder builder) {
        this.chat = builder.chat;
        this.date = builder.date;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateEncryption.super.identifier();
    }

    private ImmutableUpdateEncryption(int identifier, EncryptedChat chat, int date) {
        this.identifier = identifier;
        this.chat = chat;
        this.date = date;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public EncryptedChat chat() {
        return this.chat;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableUpdateEncryption withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateEncryption(value, this.chat, this.date);
    }

    public final ImmutableUpdateEncryption withChat(EncryptedChat value) {
        if (this.chat == value) {
            return this;
        }
        EncryptedChat newValue = Objects.requireNonNull(value, "chat");
        return new ImmutableUpdateEncryption(this.identifier, newValue, this.date);
    }

    public final ImmutableUpdateEncryption withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableUpdateEncryption(this.identifier, this.chat, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateEncryption && this.equalTo(0, (ImmutableUpdateEncryption)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateEncryption another) {
        return this.identifier == another.identifier && this.chat.equals(another.chat) && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.chat.hashCode();
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "UpdateEncryption{identifier=" + this.identifier + ", chat=" + this.chat + ", date=" + this.date + "}";
    }

    public static ImmutableUpdateEncryption of(EncryptedChat chat, int date) {
        return new ImmutableUpdateEncryption(chat, date);
    }

    public static ImmutableUpdateEncryption copyOf(UpdateEncryption instance) {
        if (instance instanceof ImmutableUpdateEncryption) {
            return (ImmutableUpdateEncryption)instance;
        }
        return ImmutableUpdateEncryption.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private EncryptedChat chat;
        private int date;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateEncryption instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateEncryption) {
                instance = (UpdateEncryption)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.chat(instance.chat());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chat(EncryptedChat chat) {
            this.chat = Objects.requireNonNull(chat, "chat");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateEncryption build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateEncryption(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chat");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build UpdateEncryption, some of required attributes are not set " + attributes;
        }
    }
}

