/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateFavedStickers;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateFavedStickers
implements UpdateFavedStickers {
    private final int identifier;
    private static final ImmutableUpdateFavedStickers INSTANCE = ImmutableUpdateFavedStickers.validate(new ImmutableUpdateFavedStickers());

    private ImmutableUpdateFavedStickers() {
        this.identifier = UpdateFavedStickers.super.identifier();
    }

    private ImmutableUpdateFavedStickers(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateFavedStickers.super.identifier();
    }

    private ImmutableUpdateFavedStickers(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableUpdateFavedStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUpdateFavedStickers.validate(new ImmutableUpdateFavedStickers(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateFavedStickers && this.equalTo(0, (ImmutableUpdateFavedStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateFavedStickers another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "UpdateFavedStickers{identifier=" + this.identifier + "}";
    }

    public static ImmutableUpdateFavedStickers of() {
        return INSTANCE;
    }

    private static ImmutableUpdateFavedStickers validate(ImmutableUpdateFavedStickers instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUpdateFavedStickers copyOf(UpdateFavedStickers instance) {
        if (instance instanceof ImmutableUpdateFavedStickers) {
            return (ImmutableUpdateFavedStickers)instance;
        }
        return ImmutableUpdateFavedStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateFavedStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateFavedStickers) {
                instance = (UpdateFavedStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableUpdateFavedStickers build() {
            return ImmutableUpdateFavedStickers.validate(new ImmutableUpdateFavedStickers(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

