/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.FolderPeer;
import telegram4j.tl.PtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateFolderPeers;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateFolderPeers
implements UpdateFolderPeers {
    private final int identifier;
    private final List<FolderPeer> folderPeers;
    private final int pts;
    private final int ptsCount;

    private ImmutableUpdateFolderPeers(int pts, int ptsCount) {
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.folderPeers = Collections.emptyList();
        this.identifier = UpdateFolderPeers.super.identifier();
    }

    private ImmutableUpdateFolderPeers(Builder builder) {
        this.folderPeers = ImmutableUpdateFolderPeers.createUnmodifiableList(true, builder.folderPeers);
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateFolderPeers.super.identifier();
    }

    private ImmutableUpdateFolderPeers(int identifier, List<FolderPeer> folderPeers, int pts, int ptsCount) {
        this.identifier = identifier;
        this.folderPeers = folderPeers;
        this.pts = pts;
        this.ptsCount = ptsCount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<FolderPeer> folderPeers() {
        return this.folderPeers;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    public final ImmutableUpdateFolderPeers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateFolderPeers(value, this.folderPeers, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateFolderPeers withFolderPeers(FolderPeer ... elements) {
        List<FolderPeer> newValue = ImmutableUpdateFolderPeers.createUnmodifiableList(false, ImmutableUpdateFolderPeers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUpdateFolderPeers(this.identifier, newValue, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateFolderPeers withFolderPeers(Iterable<? extends FolderPeer> elements) {
        if (this.folderPeers == elements) {
            return this;
        }
        List<FolderPeer> newValue = ImmutableUpdateFolderPeers.createUnmodifiableList(false, ImmutableUpdateFolderPeers.createSafeList(elements, true, false));
        return new ImmutableUpdateFolderPeers(this.identifier, newValue, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateFolderPeers withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdateFolderPeers(this.identifier, this.folderPeers, value, this.ptsCount);
    }

    public final ImmutableUpdateFolderPeers withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableUpdateFolderPeers(this.identifier, this.folderPeers, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateFolderPeers && this.equalTo(0, (ImmutableUpdateFolderPeers)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateFolderPeers another) {
        return this.identifier == another.identifier && this.folderPeers.equals(another.folderPeers) && this.pts == another.pts && this.ptsCount == another.ptsCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.folderPeers.hashCode();
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        return h;
    }

    public String toString() {
        return "UpdateFolderPeers{identifier=" + this.identifier + ", folderPeers=" + this.folderPeers + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + "}";
    }

    public static ImmutableUpdateFolderPeers of(int pts, int ptsCount) {
        return new ImmutableUpdateFolderPeers(pts, ptsCount);
    }

    public static ImmutableUpdateFolderPeers copyOf(UpdateFolderPeers instance) {
        if (instance instanceof ImmutableUpdateFolderPeers) {
            return (ImmutableUpdateFolderPeers)instance;
        }
        return ImmutableUpdateFolderPeers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PTS = 1L;
        private static final long INIT_BIT_PTS_COUNT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private List<FolderPeer> folderPeers = new ArrayList<FolderPeer>();
        private int pts;
        private int ptsCount;

        private Builder() {
        }

        public final Builder from(UpdateFolderPeers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateFolderPeers) {
                instance = (UpdateFolderPeers)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllFolderPeers(instance.folderPeers());
                if ((bits & 4L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PtsUpdate) {
                instance = (PtsUpdate)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 4L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFolderPeer(FolderPeer element) {
            this.folderPeers.add(Objects.requireNonNull(element, "folderPeers element"));
            return this;
        }

        public final Builder addFolderPeers(FolderPeer ... elements) {
            for (FolderPeer element : elements) {
                this.folderPeers.add(Objects.requireNonNull(element, "folderPeers element"));
            }
            return this;
        }

        public final Builder folderPeers(Iterable<? extends FolderPeer> elements) {
            this.folderPeers.clear();
            return this.addAllFolderPeers(elements);
        }

        public final Builder addAllFolderPeers(Iterable<? extends FolderPeer> elements) {
            for (FolderPeer folderPeer : elements) {
                this.folderPeers.add(Objects.requireNonNull(folderPeer, "folderPeers element"));
            }
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateFolderPeers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateFolderPeers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ptsCount");
            }
            return "Cannot build UpdateFolderPeers, some of required attributes are not set " + attributes;
        }
    }
}

