/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.GroupCall;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateGroupCall;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateGroupCall
implements UpdateGroupCall {
    private final int identifier;
    private final long chatId;
    private final GroupCall call;

    private ImmutableUpdateGroupCall(long chatId, GroupCall call) {
        this.chatId = chatId;
        this.call = Objects.requireNonNull(call, "call");
        this.identifier = UpdateGroupCall.super.identifier();
    }

    private ImmutableUpdateGroupCall(Builder builder) {
        this.chatId = builder.chatId;
        this.call = builder.call;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateGroupCall.super.identifier();
    }

    private ImmutableUpdateGroupCall(int identifier, long chatId, GroupCall call) {
        this.identifier = identifier;
        this.chatId = chatId;
        this.call = call;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    public GroupCall call() {
        return this.call;
    }

    public final ImmutableUpdateGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateGroupCall(value, this.chatId, this.call);
    }

    public final ImmutableUpdateGroupCall withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableUpdateGroupCall(this.identifier, value, this.call);
    }

    public final ImmutableUpdateGroupCall withCall(GroupCall value) {
        if (this.call == value) {
            return this;
        }
        GroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableUpdateGroupCall(this.identifier, this.chatId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateGroupCall && this.equalTo(0, (ImmutableUpdateGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateGroupCall another) {
        return this.identifier == another.identifier && this.chatId == another.chatId && this.call.equals(another.call);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + this.call.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateGroupCall{identifier=" + this.identifier + ", chatId=" + this.chatId + ", call=" + this.call + "}";
    }

    public static ImmutableUpdateGroupCall of(long chatId, GroupCall call) {
        return new ImmutableUpdateGroupCall(chatId, call);
    }

    public static ImmutableUpdateGroupCall copyOf(UpdateGroupCall instance) {
        if (instance instanceof ImmutableUpdateGroupCall) {
            return (ImmutableUpdateGroupCall)instance;
        }
        return ImmutableUpdateGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long INIT_BIT_CALL = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long chatId;
        private GroupCall call;

        private Builder() {
        }

        public final Builder from(UpdateGroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateGroupCall) {
                instance = (UpdateGroupCall)object;
                this.call(instance.call());
                this.chatId(instance.chatId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder call(GroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("call");
            }
            return "Cannot build UpdateGroupCall, some of required attributes are not set " + attributes;
        }
    }
}

