/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DataJSON;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateGroupCallConnection;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateGroupCallConnection
implements UpdateGroupCallConnection {
    private final int identifier;
    private final int flags;
    private final boolean presentation;
    private final DataJSON params;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateGroupCallConnection(DataJSON params) {
        this.params = Objects.requireNonNull(params, "params");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.presentation = this.initShim.presentation();
        this.initShim = null;
    }

    private ImmutableUpdateGroupCallConnection(Builder builder) {
        this.params = builder.params;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.presentationIsSet()) {
            this.initShim.presentation(builder.presentation);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.presentation = this.initShim.presentation();
        this.initShim = null;
    }

    private ImmutableUpdateGroupCallConnection(int identifier, int flags, boolean presentation, DataJSON params) {
        this.identifier = identifier;
        this.flags = flags;
        this.presentation = presentation;
        this.params = params;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateGroupCallConnection.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateGroupCallConnection.super.flags();
    }

    private boolean presentationInitialize() {
        return UpdateGroupCallConnection.super.presentation();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean presentation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.presentation() : this.presentation;
    }

    @Override
    public DataJSON params() {
        return this.params;
    }

    public final ImmutableUpdateGroupCallConnection withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateGroupCallConnection(value, this.flags, this.presentation, this.params);
    }

    public final ImmutableUpdateGroupCallConnection withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateGroupCallConnection(this.identifier, value, this.presentation, this.params);
    }

    public final ImmutableUpdateGroupCallConnection withPresentation(boolean value) {
        if (this.presentation == value) {
            return this;
        }
        return new ImmutableUpdateGroupCallConnection(this.identifier, this.flags, value, this.params);
    }

    public final ImmutableUpdateGroupCallConnection withParams(DataJSON value) {
        if (this.params == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "params");
        return new ImmutableUpdateGroupCallConnection(this.identifier, this.flags, this.presentation, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateGroupCallConnection && this.equalTo(0, (ImmutableUpdateGroupCallConnection)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateGroupCallConnection another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.presentation == another.presentation && this.params.equals(another.params);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.presentation);
        h += (h << 5) + this.params.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateGroupCallConnection{identifier=" + this.identifier + ", flags=" + this.flags + ", presentation=" + this.presentation + ", params=" + this.params + "}";
    }

    public static ImmutableUpdateGroupCallConnection of(DataJSON params) {
        return new ImmutableUpdateGroupCallConnection(params);
    }

    public static ImmutableUpdateGroupCallConnection copyOf(UpdateGroupCallConnection instance) {
        if (instance instanceof ImmutableUpdateGroupCallConnection) {
            return (ImmutableUpdateGroupCallConnection)instance;
        }
        return ImmutableUpdateGroupCallConnection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PARAMS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PRESENTATION = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean presentation;
        private DataJSON params;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateGroupCallConnection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateGroupCallConnection) {
                instance = (UpdateGroupCallConnection)object;
                this.presentation(instance.presentation());
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.params(instance.params());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder presentation(boolean presentation) {
            this.presentation = presentation;
            this.optBits |= 4L;
            return this;
        }

        public final Builder params(DataJSON params) {
            this.params = Objects.requireNonNull(params, "params");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateGroupCallConnection build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateGroupCallConnection(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean presentationIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("params");
            }
            return "Cannot build UpdateGroupCallConnection, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte presentationBuildStage = 0;
        private boolean presentation;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateGroupCallConnection.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateGroupCallConnection.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean presentation() {
            if (this.presentationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.presentationBuildStage == 0) {
                this.presentationBuildStage = (byte)-1;
                this.presentation = ImmutableUpdateGroupCallConnection.this.presentationInitialize();
                this.presentationBuildStage = 1;
            }
            return this.presentation;
        }

        void presentation(boolean presentation) {
            this.presentation = presentation;
            this.presentationBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.presentationBuildStage == -1) {
                attributes.add("presentation");
            }
            return "Cannot build UpdateGroupCallConnection, attribute initializers form cycle " + attributes;
        }
    }
}

