/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.GroupCallParticipant;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateGroupCallParticipants;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateGroupCallParticipants
implements UpdateGroupCallParticipants {
    private final int identifier;
    private final InputGroupCall call;
    private final List<GroupCallParticipant> participants;
    private final int version;

    private ImmutableUpdateGroupCallParticipants(InputGroupCall call, int version) {
        this.call = Objects.requireNonNull(call, "call");
        this.version = version;
        this.participants = Collections.emptyList();
        this.identifier = UpdateGroupCallParticipants.super.identifier();
    }

    private ImmutableUpdateGroupCallParticipants(Builder builder) {
        this.call = builder.call;
        this.participants = ImmutableUpdateGroupCallParticipants.createUnmodifiableList(true, builder.participants);
        this.version = builder.version;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateGroupCallParticipants.super.identifier();
    }

    private ImmutableUpdateGroupCallParticipants(int identifier, InputGroupCall call, List<GroupCallParticipant> participants, int version) {
        this.identifier = identifier;
        this.call = call;
        this.participants = participants;
        this.version = version;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    public List<GroupCallParticipant> participants() {
        return this.participants;
    }

    @Override
    public int version() {
        return this.version;
    }

    public final ImmutableUpdateGroupCallParticipants withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateGroupCallParticipants(value, this.call, this.participants, this.version);
    }

    public final ImmutableUpdateGroupCallParticipants withCall(InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        InputGroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableUpdateGroupCallParticipants(this.identifier, newValue, this.participants, this.version);
    }

    public final ImmutableUpdateGroupCallParticipants withParticipants(GroupCallParticipant ... elements) {
        List<GroupCallParticipant> newValue = ImmutableUpdateGroupCallParticipants.createUnmodifiableList(false, ImmutableUpdateGroupCallParticipants.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUpdateGroupCallParticipants(this.identifier, this.call, newValue, this.version);
    }

    public final ImmutableUpdateGroupCallParticipants withParticipants(Iterable<? extends GroupCallParticipant> elements) {
        if (this.participants == elements) {
            return this;
        }
        List<GroupCallParticipant> newValue = ImmutableUpdateGroupCallParticipants.createUnmodifiableList(false, ImmutableUpdateGroupCallParticipants.createSafeList(elements, true, false));
        return new ImmutableUpdateGroupCallParticipants(this.identifier, this.call, newValue, this.version);
    }

    public final ImmutableUpdateGroupCallParticipants withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableUpdateGroupCallParticipants(this.identifier, this.call, this.participants, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateGroupCallParticipants && this.equalTo(0, (ImmutableUpdateGroupCallParticipants)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateGroupCallParticipants another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.participants.equals(another.participants) && this.version == another.version;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.participants.hashCode();
        h += (h << 5) + this.version;
        return h;
    }

    public String toString() {
        return "UpdateGroupCallParticipants{identifier=" + this.identifier + ", call=" + this.call + ", participants=" + this.participants + ", version=" + this.version + "}";
    }

    public static ImmutableUpdateGroupCallParticipants of(InputGroupCall call, int version) {
        return new ImmutableUpdateGroupCallParticipants(call, version);
    }

    public static ImmutableUpdateGroupCallParticipants copyOf(UpdateGroupCallParticipants instance) {
        if (instance instanceof ImmutableUpdateGroupCallParticipants) {
            return (ImmutableUpdateGroupCallParticipants)instance;
        }
        return ImmutableUpdateGroupCallParticipants.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputGroupCall call;
        private List<GroupCallParticipant> participants = new ArrayList<GroupCallParticipant>();
        private int version;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateGroupCallParticipants instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateGroupCallParticipants) {
                instance = (UpdateGroupCallParticipants)object;
                this.call(instance.call());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.version(instance.version());
                this.addAllParticipants(instance.participants());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(InputGroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addParticipant(GroupCallParticipant element) {
            this.participants.add(Objects.requireNonNull(element, "participants element"));
            return this;
        }

        public final Builder addParticipants(GroupCallParticipant ... elements) {
            for (GroupCallParticipant element : elements) {
                this.participants.add(Objects.requireNonNull(element, "participants element"));
            }
            return this;
        }

        public final Builder participants(Iterable<? extends GroupCallParticipant> elements) {
            this.participants.clear();
            return this.addAllParticipants(elements);
        }

        public final Builder addAllParticipants(Iterable<? extends GroupCallParticipant> elements) {
            for (GroupCallParticipant groupCallParticipant : elements) {
                this.participants.add(Objects.requireNonNull(groupCallParticipant, "participants element"));
            }
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateGroupCallParticipants build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateGroupCallParticipants(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build UpdateGroupCallParticipants, some of required attributes are not set " + attributes;
        }
    }
}

