/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputBotInlineMessageID;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateInlineBotCallbackQuery;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateInlineBotCallbackQuery
implements UpdateInlineBotCallbackQuery {
    private final int identifier;
    private final int flags;
    private final long queryId;
    private final long userId;
    private final InputBotInlineMessageID msgId;
    private final long chatInstance;
    private final ByteBuf data;
    @Nullable
    private final String gameShortName;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateInlineBotCallbackQuery(long queryId, long userId, InputBotInlineMessageID msgId, long chatInstance) {
        this.queryId = queryId;
        this.userId = userId;
        this.msgId = Objects.requireNonNull(msgId, "msgId");
        this.chatInstance = chatInstance;
        this.data = null;
        this.gameShortName = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateInlineBotCallbackQuery(Builder builder) {
        this.queryId = builder.queryId;
        this.userId = builder.userId;
        this.msgId = builder.msgId;
        this.chatInstance = builder.chatInstance;
        this.data = builder.data_build();
        this.gameShortName = builder.gameShortName;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateInlineBotCallbackQuery(int identifier, int flags, long queryId, long userId, InputBotInlineMessageID msgId, long chatInstance, ByteBuf data, @Nullable String gameShortName) {
        this.identifier = identifier;
        this.flags = flags;
        this.queryId = queryId;
        this.userId = userId;
        this.msgId = msgId;
        this.chatInstance = chatInstance;
        this.data = data;
        this.gameShortName = gameShortName;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateInlineBotCallbackQuery.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateInlineBotCallbackQuery.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public InputBotInlineMessageID msgId() {
        return this.msgId;
    }

    @Override
    public long chatInstance() {
        return this.chatInstance;
    }

    @Override
    public Optional<ByteBuf> data() {
        return Optional.ofNullable(this.data).map(ByteBuf::duplicate);
    }

    @Override
    @Nullable
    public String gameShortName() {
        return this.gameShortName;
    }

    public final ImmutableUpdateInlineBotCallbackQuery withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateInlineBotCallbackQuery(value, this.flags, this.queryId, this.userId, this.msgId, this.chatInstance, this.data, this.gameShortName);
    }

    public final ImmutableUpdateInlineBotCallbackQuery withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateInlineBotCallbackQuery(this.identifier, value, this.queryId, this.userId, this.msgId, this.chatInstance, this.data, this.gameShortName);
    }

    public final ImmutableUpdateInlineBotCallbackQuery withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableUpdateInlineBotCallbackQuery(this.identifier, this.flags, value, this.userId, this.msgId, this.chatInstance, this.data, this.gameShortName);
    }

    public final ImmutableUpdateInlineBotCallbackQuery withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateInlineBotCallbackQuery(this.identifier, this.flags, this.queryId, value, this.msgId, this.chatInstance, this.data, this.gameShortName);
    }

    public final ImmutableUpdateInlineBotCallbackQuery withMsgId(InputBotInlineMessageID value) {
        if (this.msgId == value) {
            return this;
        }
        InputBotInlineMessageID newValue = Objects.requireNonNull(value, "msgId");
        return new ImmutableUpdateInlineBotCallbackQuery(this.identifier, this.flags, this.queryId, this.userId, newValue, this.chatInstance, this.data, this.gameShortName);
    }

    public final ImmutableUpdateInlineBotCallbackQuery withChatInstance(long value) {
        if (this.chatInstance == value) {
            return this;
        }
        return new ImmutableUpdateInlineBotCallbackQuery(this.identifier, this.flags, this.queryId, this.userId, this.msgId, value, this.data, this.gameShortName);
    }

    public ImmutableUpdateInlineBotCallbackQuery withData(Optional<ByteBuf> value) {
        ByteBuf newValue = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableUpdateInlineBotCallbackQuery(this.identifier, this.flags, this.queryId, this.userId, this.msgId, this.chatInstance, newValue, this.gameShortName);
    }

    public ImmutableUpdateInlineBotCallbackQuery withData(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableUpdateInlineBotCallbackQuery(this.identifier, this.flags, this.queryId, this.userId, this.msgId, this.chatInstance, newValue, this.gameShortName);
    }

    public final ImmutableUpdateInlineBotCallbackQuery withGameShortName(@Nullable String value) {
        if (Objects.equals(this.gameShortName, value)) {
            return this;
        }
        return new ImmutableUpdateInlineBotCallbackQuery(this.identifier, this.flags, this.queryId, this.userId, this.msgId, this.chatInstance, this.data, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateInlineBotCallbackQuery && this.equalTo(0, (ImmutableUpdateInlineBotCallbackQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateInlineBotCallbackQuery another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.queryId == another.queryId && this.userId == another.userId && this.msgId.equals(another.msgId) && this.chatInstance == another.chatInstance && this.data().equals(another.data()) && Objects.equals(this.gameShortName, another.gameShortName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.msgId.hashCode();
        h += (h << 5) + Long.hashCode(this.chatInstance);
        h += (h << 5) + this.data().hashCode();
        h += (h << 5) + Objects.hashCode(this.gameShortName);
        return h;
    }

    public String toString() {
        return "UpdateInlineBotCallbackQuery{identifier=" + this.identifier + ", flags=" + this.flags + ", queryId=" + this.queryId + ", userId=" + this.userId + ", msgId=" + this.msgId + ", chatInstance=" + this.chatInstance + ", data=" + this.data().map(ByteBufUtil::hexDump).toString() + ", gameShortName=" + this.gameShortName + "}";
    }

    public static ImmutableUpdateInlineBotCallbackQuery of(long queryId, long userId, InputBotInlineMessageID msgId, long chatInstance) {
        return new ImmutableUpdateInlineBotCallbackQuery(queryId, userId, msgId, chatInstance);
    }

    public static ImmutableUpdateInlineBotCallbackQuery copyOf(UpdateInlineBotCallbackQuery instance) {
        if (instance instanceof ImmutableUpdateInlineBotCallbackQuery) {
            return (ImmutableUpdateInlineBotCallbackQuery)instance;
        }
        return ImmutableUpdateInlineBotCallbackQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_MSG_ID = 4L;
        private static final long INIT_BIT_CHAT_INSTANCE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 15L;
        private long optBits;
        private ByteBuf data_value = null;
        private int identifier;
        private int flags;
        private long queryId;
        private long userId;
        private InputBotInlineMessageID msgId;
        private long chatInstance;
        private String gameShortName;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateInlineBotCallbackQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateInlineBotCallbackQuery) {
                instance = (UpdateInlineBotCallbackQuery)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.data(instance.data());
                this.flags(instance.flags());
                this.msgId(instance.msgId());
                String gameShortNameValue = instance.gameShortName();
                if (gameShortNameValue != null) {
                    this.gameShortName(gameShortNameValue);
                }
                this.userId(instance.userId());
                this.queryId(instance.queryId());
                this.chatInstance(instance.chatInstance());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder msgId(InputBotInlineMessageID msgId) {
            this.msgId = Objects.requireNonNull(msgId, "msgId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder chatInstance(long chatInstance) {
            this.chatInstance = chatInstance;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder data(@Nullable ByteBuf value) {
            this.data_value = value != null ? TlEncodingUtil.copyAsUnpooled((ByteBuf)value) : null;
            return this;
        }

        public Builder data(Optional<ByteBuf> value) {
            this.data_value = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
            return this;
        }

        public final Builder gameShortName(@Nullable String gameShortName) {
            this.gameShortName = gameShortName;
            return this;
        }

        public ImmutableUpdateInlineBotCallbackQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateInlineBotCallbackQuery(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("chatInstance");
            }
            return "Cannot build UpdateInlineBotCallbackQuery, some of required attributes are not set " + attributes;
        }

        private ByteBuf data_build() {
            return this.data_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateInlineBotCallbackQuery.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateInlineBotCallbackQuery.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateInlineBotCallbackQuery, attribute initializers form cycle " + attributes;
        }
    }
}

