/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.LangPackDifference;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateLangPack;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateLangPack
implements UpdateLangPack {
    private final int identifier;
    private final LangPackDifference difference;

    private ImmutableUpdateLangPack(LangPackDifference difference) {
        this.difference = Objects.requireNonNull(difference, "difference");
        this.identifier = UpdateLangPack.super.identifier();
    }

    private ImmutableUpdateLangPack(Builder builder) {
        this.difference = builder.difference;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateLangPack.super.identifier();
    }

    private ImmutableUpdateLangPack(int identifier, LangPackDifference difference) {
        this.identifier = identifier;
        this.difference = difference;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public LangPackDifference difference() {
        return this.difference;
    }

    public final ImmutableUpdateLangPack withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateLangPack(value, this.difference);
    }

    public final ImmutableUpdateLangPack withDifference(LangPackDifference value) {
        if (this.difference == value) {
            return this;
        }
        LangPackDifference newValue = Objects.requireNonNull(value, "difference");
        return new ImmutableUpdateLangPack(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateLangPack && this.equalTo(0, (ImmutableUpdateLangPack)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateLangPack another) {
        return this.identifier == another.identifier && this.difference.equals(another.difference);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.difference.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateLangPack{identifier=" + this.identifier + ", difference=" + this.difference + "}";
    }

    public static ImmutableUpdateLangPack of(LangPackDifference difference) {
        return new ImmutableUpdateLangPack(difference);
    }

    public static ImmutableUpdateLangPack copyOf(UpdateLangPack instance) {
        if (instance instanceof ImmutableUpdateLangPack) {
            return (ImmutableUpdateLangPack)instance;
        }
        return ImmutableUpdateLangPack.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DIFFERENCE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private LangPackDifference difference;

        private Builder() {
        }

        public final Builder from(UpdateLangPack instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateLangPack) {
                instance = (UpdateLangPack)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.difference(instance.difference());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder difference(LangPackDifference difference) {
            this.difference = Objects.requireNonNull(difference, "difference");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateLangPack build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateLangPack(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("difference");
            }
            return "Cannot build UpdateLangPack, some of required attributes are not set " + attributes;
        }
    }
}

