/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateLoginToken;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateLoginToken
implements UpdateLoginToken {
    private final int identifier;
    private static final ImmutableUpdateLoginToken INSTANCE = ImmutableUpdateLoginToken.validate(new ImmutableUpdateLoginToken());

    private ImmutableUpdateLoginToken() {
        this.identifier = UpdateLoginToken.super.identifier();
    }

    private ImmutableUpdateLoginToken(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateLoginToken.super.identifier();
    }

    private ImmutableUpdateLoginToken(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableUpdateLoginToken withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUpdateLoginToken.validate(new ImmutableUpdateLoginToken(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateLoginToken && this.equalTo(0, (ImmutableUpdateLoginToken)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateLoginToken another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "UpdateLoginToken{identifier=" + this.identifier + "}";
    }

    public static ImmutableUpdateLoginToken of() {
        return INSTANCE;
    }

    private static ImmutableUpdateLoginToken validate(ImmutableUpdateLoginToken instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUpdateLoginToken copyOf(UpdateLoginToken instance) {
        if (instance instanceof ImmutableUpdateLoginToken) {
            return (ImmutableUpdateLoginToken)instance;
        }
        return ImmutableUpdateLoginToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(UpdateLoginToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateLoginToken) {
                instance = (UpdateLoginToken)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableUpdateLoginToken build() {
            return ImmutableUpdateLoginToken.validate(new ImmutableUpdateLoginToken(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

