/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateMessageID;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateMessageID
implements UpdateMessageID {
    private final int identifier;
    private final int id;
    private final long randomId;

    private ImmutableUpdateMessageID(int id, long randomId) {
        this.id = id;
        this.randomId = randomId;
        this.identifier = UpdateMessageID.super.identifier();
    }

    private ImmutableUpdateMessageID(Builder builder) {
        this.id = builder.id;
        this.randomId = builder.randomId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateMessageID.super.identifier();
    }

    private ImmutableUpdateMessageID(int identifier, int id, long randomId) {
        this.identifier = identifier;
        this.id = id;
        this.randomId = randomId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public long randomId() {
        return this.randomId;
    }

    public final ImmutableUpdateMessageID withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateMessageID(value, this.id, this.randomId);
    }

    public final ImmutableUpdateMessageID withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableUpdateMessageID(this.identifier, value, this.randomId);
    }

    public final ImmutableUpdateMessageID withRandomId(long value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableUpdateMessageID(this.identifier, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateMessageID && this.equalTo(0, (ImmutableUpdateMessageID)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateMessageID another) {
        return this.identifier == another.identifier && this.id == another.id && this.randomId == another.randomId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id;
        h += (h << 5) + Long.hashCode(this.randomId);
        return h;
    }

    public String toString() {
        return "UpdateMessageID{identifier=" + this.identifier + ", id=" + this.id + ", randomId=" + this.randomId + "}";
    }

    public static ImmutableUpdateMessageID of(int id, long randomId) {
        return new ImmutableUpdateMessageID(id, randomId);
    }

    public static ImmutableUpdateMessageID copyOf(UpdateMessageID instance) {
        if (instance instanceof ImmutableUpdateMessageID) {
            return (ImmutableUpdateMessageID)instance;
        }
        return ImmutableUpdateMessageID.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_RANDOM_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int id;
        private long randomId;

        private Builder() {
        }

        public final Builder from(UpdateMessageID instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateMessageID) {
                instance = (UpdateMessageID)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.randomId(instance.randomId());
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder randomId(long randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateMessageID build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateMessageID(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("randomId");
            }
            return "Cannot build UpdateMessageID, some of required attributes are not set " + attributes;
        }
    }
}

