/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Poll;
import telegram4j.tl.PollResults;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateMessagePoll;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateMessagePoll
implements UpdateMessagePoll {
    private final int identifier;
    private final int flags;
    private final long pollId;
    @Nullable
    private final Poll poll;
    private final PollResults results;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateMessagePoll(long pollId, PollResults results) {
        this.pollId = pollId;
        this.results = Objects.requireNonNull(results, "results");
        this.poll = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateMessagePoll(Builder builder) {
        this.pollId = builder.pollId;
        this.poll = builder.poll;
        this.results = builder.results;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateMessagePoll(int identifier, int flags, long pollId, @Nullable Poll poll, PollResults results) {
        this.identifier = identifier;
        this.flags = flags;
        this.pollId = pollId;
        this.poll = poll;
        this.results = results;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateMessagePoll.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateMessagePoll.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long pollId() {
        return this.pollId;
    }

    @Override
    @Nullable
    public Poll poll() {
        return this.poll;
    }

    @Override
    public PollResults results() {
        return this.results;
    }

    public final ImmutableUpdateMessagePoll withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateMessagePoll(value, this.flags, this.pollId, this.poll, this.results);
    }

    public final ImmutableUpdateMessagePoll withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateMessagePoll(this.identifier, value, this.pollId, this.poll, this.results);
    }

    public final ImmutableUpdateMessagePoll withPollId(long value) {
        if (this.pollId == value) {
            return this;
        }
        return new ImmutableUpdateMessagePoll(this.identifier, this.flags, value, this.poll, this.results);
    }

    public final ImmutableUpdateMessagePoll withPoll(@Nullable Poll value) {
        if (this.poll == value) {
            return this;
        }
        return new ImmutableUpdateMessagePoll(this.identifier, this.flags, this.pollId, value, this.results);
    }

    public final ImmutableUpdateMessagePoll withResults(PollResults value) {
        if (this.results == value) {
            return this;
        }
        PollResults newValue = Objects.requireNonNull(value, "results");
        return new ImmutableUpdateMessagePoll(this.identifier, this.flags, this.pollId, this.poll, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateMessagePoll && this.equalTo(0, (ImmutableUpdateMessagePoll)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateMessagePoll another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.pollId == another.pollId && Objects.equals(this.poll, another.poll) && this.results.equals(another.results);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.pollId);
        h += (h << 5) + Objects.hashCode(this.poll);
        h += (h << 5) + this.results.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateMessagePoll{identifier=" + this.identifier + ", flags=" + this.flags + ", pollId=" + this.pollId + ", poll=" + this.poll + ", results=" + this.results + "}";
    }

    public static ImmutableUpdateMessagePoll of(long pollId, PollResults results) {
        return new ImmutableUpdateMessagePoll(pollId, results);
    }

    public static ImmutableUpdateMessagePoll copyOf(UpdateMessagePoll instance) {
        if (instance instanceof ImmutableUpdateMessagePoll) {
            return (ImmutableUpdateMessagePoll)instance;
        }
        return ImmutableUpdateMessagePoll.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_POLL_ID = 1L;
        private static final long INIT_BIT_RESULTS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private long pollId;
        private Poll poll;
        private PollResults results;

        private Builder() {
        }

        public final Builder from(UpdateMessagePoll instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateMessagePoll) {
                Poll pollValue;
                instance = (UpdateMessagePoll)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((pollValue = instance.poll()) != null) {
                    this.poll(pollValue);
                }
                this.results(instance.results());
                this.pollId(instance.pollId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder pollId(long pollId) {
            this.pollId = pollId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder poll(@Nullable Poll poll) {
            this.poll = poll;
            return this;
        }

        public final Builder results(PollResults results) {
            this.results = Objects.requireNonNull(results, "results");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateMessagePoll build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateMessagePoll(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pollId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("results");
            }
            return "Cannot build UpdateMessagePoll, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateMessagePoll.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateMessagePoll.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateMessagePoll, attribute initializers form cycle " + attributes;
        }
    }
}

