/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import telegram4j.tl.QtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateMessagePollVote;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateMessagePollVote
implements UpdateMessagePollVote {
    private final int identifier;
    private final long pollId;
    private final long userId;
    private final List<ByteBuf> options;
    private final int qts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateMessagePollVote(long pollId, long userId, int qts) {
        this.pollId = pollId;
        this.userId = userId;
        this.qts = qts;
        this.options = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableUpdateMessagePollVote(Builder builder) {
        this.pollId = builder.pollId;
        this.userId = builder.userId;
        this.options = builder.options_build();
        this.qts = builder.qts;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableUpdateMessagePollVote(int identifier, long pollId, long userId, List<ByteBuf> options, int qts) {
        this.identifier = identifier;
        this.pollId = pollId;
        this.userId = userId;
        this.options = options;
        this.qts = qts;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateMessagePollVote.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long pollId() {
        return this.pollId;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public List<ByteBuf> options() {
        return this.options.stream().map(ByteBuf::duplicate).collect(Collectors.toList());
    }

    @Override
    public int qts() {
        return this.qts;
    }

    public final ImmutableUpdateMessagePollVote withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateMessagePollVote(value, this.pollId, this.userId, this.options, this.qts);
    }

    public final ImmutableUpdateMessagePollVote withPollId(long value) {
        if (this.pollId == value) {
            return this;
        }
        return new ImmutableUpdateMessagePollVote(this.identifier, value, this.userId, this.options, this.qts);
    }

    public final ImmutableUpdateMessagePollVote withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableUpdateMessagePollVote(this.identifier, this.pollId, value, this.options, this.qts);
    }

    public ImmutableUpdateMessagePollVote withOptions(Iterable<? extends ByteBuf> value) {
        List<ByteBuf> newValue = StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
        if (this.options == newValue) {
            return this;
        }
        return new ImmutableUpdateMessagePollVote(this.identifier, this.pollId, this.userId, newValue, this.qts);
    }

    public final ImmutableUpdateMessagePollVote withQts(int value) {
        if (this.qts == value) {
            return this;
        }
        return new ImmutableUpdateMessagePollVote(this.identifier, this.pollId, this.userId, this.options, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateMessagePollVote && this.equalTo(0, (ImmutableUpdateMessagePollVote)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateMessagePollVote another) {
        return this.identifier == another.identifier && this.pollId == another.pollId && this.userId == another.userId && this.options().equals(another.options()) && this.qts == another.qts;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.pollId);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.options().hashCode();
        h += (h << 5) + this.qts;
        return h;
    }

    public String toString() {
        return "UpdateMessagePollVote{identifier=" + this.identifier + ", pollId=" + this.pollId + ", userId=" + this.userId + ", options=" + this.options.stream().map(ByteBufUtil::hexDump).collect(Collectors.joining(", ", "[", "]")) + ", qts=" + this.qts + "}";
    }

    public static ImmutableUpdateMessagePollVote of(long pollId, long userId, int qts) {
        return new ImmutableUpdateMessagePollVote(pollId, userId, qts);
    }

    public static ImmutableUpdateMessagePollVote copyOf(UpdateMessagePollVote instance) {
        if (instance instanceof ImmutableUpdateMessagePollVote) {
            return (ImmutableUpdateMessagePollVote)instance;
        }
        return ImmutableUpdateMessagePollVote.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_POLL_ID = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_QTS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private List<ByteBuf> options_value = null;
        private int identifier;
        private long pollId;
        private long userId;
        private int qts;

        private Builder() {
        }

        public final Builder from(QtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateMessagePollVote instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof QtsUpdate) {
                instance = (QtsUpdate)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.qts(instance.qts());
                    bits |= 2L;
                }
            }
            if (object instanceof UpdateMessagePollVote) {
                instance = (UpdateMessagePollVote)object;
                this.options(instance.options());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.qts(instance.qts());
                    bits |= 2L;
                }
                this.userId(instance.userId());
                this.pollId(instance.pollId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pollId(long pollId) {
            this.pollId = pollId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder addOption(ByteBuf value) {
            this.options_getOrCreate().add(TlEncodingUtil.copyAsUnpooled((ByteBuf)value));
            return this;
        }

        public Builder addAllOptions(Iterable<? extends ByteBuf> value) {
            this.options_getOrCreate().addAll(StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder addAllOptions(ByteBuf ... value) {
            this.options_getOrCreate().addAll(Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder options(Iterable<? extends ByteBuf> value) {
            this.options_value = StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
            return this;
        }

        public Builder options(ByteBuf ... value) {
            this.options_value = Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
            return this;
        }

        public final Builder qts(int qts) {
            this.qts = qts;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateMessagePollVote build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateMessagePollVote(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pollId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("qts");
            }
            return "Cannot build UpdateMessagePollVote, some of required attributes are not set " + attributes;
        }

        private List<ByteBuf> options_build() {
            return TlEncodingUtil.unmodifiableList(this.options_value);
        }

        private List<ByteBuf> options_getOrCreate() {
            if (this.options_value == null) {
                this.options_value = new ArrayList<ByteBuf>();
            }
            return this.options_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateMessagePollVote.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build UpdateMessagePollVote, attribute initializers form cycle " + attributes;
        }
    }
}

