/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageReactions;
import telegram4j.tl.Peer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateMessageReactions;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateMessageReactions
implements UpdateMessageReactions {
    private final int identifier;
    private final Peer peer;
    private final int msgId;
    private final MessageReactions reactions;

    private ImmutableUpdateMessageReactions(Peer peer, int msgId, MessageReactions reactions) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.msgId = msgId;
        this.reactions = Objects.requireNonNull(reactions, "reactions");
        this.identifier = UpdateMessageReactions.super.identifier();
    }

    private ImmutableUpdateMessageReactions(Builder builder) {
        this.peer = builder.peer;
        this.msgId = builder.msgId;
        this.reactions = builder.reactions;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateMessageReactions.super.identifier();
    }

    private ImmutableUpdateMessageReactions(int identifier, Peer peer, int msgId, MessageReactions reactions) {
        this.identifier = identifier;
        this.peer = peer;
        this.msgId = msgId;
        this.reactions = reactions;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public int msgId() {
        return this.msgId;
    }

    @Override
    public MessageReactions reactions() {
        return this.reactions;
    }

    public final ImmutableUpdateMessageReactions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateMessageReactions(value, this.peer, this.msgId, this.reactions);
    }

    public final ImmutableUpdateMessageReactions withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateMessageReactions(this.identifier, newValue, this.msgId, this.reactions);
    }

    public final ImmutableUpdateMessageReactions withMsgId(int value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableUpdateMessageReactions(this.identifier, this.peer, value, this.reactions);
    }

    public final ImmutableUpdateMessageReactions withReactions(MessageReactions value) {
        if (this.reactions == value) {
            return this;
        }
        MessageReactions newValue = Objects.requireNonNull(value, "reactions");
        return new ImmutableUpdateMessageReactions(this.identifier, this.peer, this.msgId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateMessageReactions && this.equalTo(0, (ImmutableUpdateMessageReactions)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateMessageReactions another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.msgId == another.msgId && this.reactions.equals(another.reactions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.msgId;
        h += (h << 5) + this.reactions.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateMessageReactions{identifier=" + this.identifier + ", peer=" + this.peer + ", msgId=" + this.msgId + ", reactions=" + this.reactions + "}";
    }

    public static ImmutableUpdateMessageReactions of(Peer peer, int msgId, MessageReactions reactions) {
        return new ImmutableUpdateMessageReactions(peer, msgId, reactions);
    }

    public static ImmutableUpdateMessageReactions copyOf(UpdateMessageReactions instance) {
        if (instance instanceof ImmutableUpdateMessageReactions) {
            return (ImmutableUpdateMessageReactions)instance;
        }
        return ImmutableUpdateMessageReactions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_MSG_ID = 2L;
        private static final long INIT_BIT_REACTIONS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private int msgId;
        private MessageReactions reactions;

        private Builder() {
        }

        public final Builder from(UpdateMessageReactions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateMessageReactions) {
                instance = (UpdateMessageReactions)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.reactions(instance.reactions());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder msgId(int msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder reactions(MessageReactions reactions) {
            this.reactions = Objects.requireNonNull(reactions, "reactions");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateMessageReactions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateMessageReactions(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("reactions");
            }
            return "Cannot build UpdateMessageReactions, some of required attributes are not set " + attributes;
        }
    }
}

