/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Message;
import telegram4j.tl.PtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateNewChannelMessage;
import telegram4j.tl.UpdateNewMessageFields;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateNewChannelMessage
implements UpdateNewChannelMessage {
    private final int identifier;
    private final Message message;
    private final int pts;
    private final int ptsCount;

    private ImmutableUpdateNewChannelMessage(Message message, int pts, int ptsCount) {
        this.message = Objects.requireNonNull(message, "message");
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.identifier = UpdateNewChannelMessage.super.identifier();
    }

    private ImmutableUpdateNewChannelMessage(Builder builder) {
        this.message = builder.message;
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateNewChannelMessage.super.identifier();
    }

    private ImmutableUpdateNewChannelMessage(int identifier, Message message, int pts, int ptsCount) {
        this.identifier = identifier;
        this.message = message;
        this.pts = pts;
        this.ptsCount = ptsCount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Message message() {
        return this.message;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    public final ImmutableUpdateNewChannelMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateNewChannelMessage(value, this.message, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateNewChannelMessage withMessage(Message value) {
        if (this.message == value) {
            return this;
        }
        Message newValue = Objects.requireNonNull(value, "message");
        return new ImmutableUpdateNewChannelMessage(this.identifier, newValue, this.pts, this.ptsCount);
    }

    public final ImmutableUpdateNewChannelMessage withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableUpdateNewChannelMessage(this.identifier, this.message, value, this.ptsCount);
    }

    public final ImmutableUpdateNewChannelMessage withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableUpdateNewChannelMessage(this.identifier, this.message, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateNewChannelMessage && this.equalTo(0, (ImmutableUpdateNewChannelMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateNewChannelMessage another) {
        return this.identifier == another.identifier && this.message.equals(another.message) && this.pts == another.pts && this.ptsCount == another.ptsCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        return h;
    }

    public String toString() {
        return "UpdateNewChannelMessage{identifier=" + this.identifier + ", message=" + this.message + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + "}";
    }

    public static ImmutableUpdateNewChannelMessage of(Message message, int pts, int ptsCount) {
        return new ImmutableUpdateNewChannelMessage(message, pts, ptsCount);
    }

    public static ImmutableUpdateNewChannelMessage copyOf(UpdateNewChannelMessage instance) {
        if (instance instanceof ImmutableUpdateNewChannelMessage) {
            return (ImmutableUpdateNewChannelMessage)instance;
        }
        return ImmutableUpdateNewChannelMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long INIT_BIT_PTS = 2L;
        private static final long INIT_BIT_PTS_COUNT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private Message message;
        private int pts;
        private int ptsCount;

        private Builder() {
        }

        public final Builder from(UpdateNewChannelMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateNewMessageFields instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateNewChannelMessage) {
                instance = (UpdateNewChannelMessage)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.message(instance.message());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 8L;
                }
            }
            if (object instanceof UpdateNewMessageFields) {
                instance = (UpdateNewMessageFields)object;
                if ((bits & 4L) == 0L) {
                    this.message(instance.message());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PtsUpdate) {
                instance = (PtsUpdate)object;
                if ((bits & 2L) == 0L) {
                    this.ptsCount(instance.ptsCount());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.pts(instance.pts());
                    bits |= 8L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder message(Message message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUpdateNewChannelMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateNewChannelMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ptsCount");
            }
            return "Cannot build UpdateNewChannelMessage, some of required attributes are not set " + attributes;
        }
    }
}

