/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.EncryptedMessage;
import telegram4j.tl.QtsUpdate;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateNewEncryptedMessage;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateNewEncryptedMessage
implements UpdateNewEncryptedMessage {
    private final int identifier;
    private final EncryptedMessage message;
    private final int qts;

    private ImmutableUpdateNewEncryptedMessage(EncryptedMessage message, int qts) {
        this.message = Objects.requireNonNull(message, "message");
        this.qts = qts;
        this.identifier = UpdateNewEncryptedMessage.super.identifier();
    }

    private ImmutableUpdateNewEncryptedMessage(Builder builder) {
        this.message = builder.message;
        this.qts = builder.qts;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateNewEncryptedMessage.super.identifier();
    }

    private ImmutableUpdateNewEncryptedMessage(int identifier, EncryptedMessage message, int qts) {
        this.identifier = identifier;
        this.message = message;
        this.qts = qts;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public EncryptedMessage message() {
        return this.message;
    }

    @Override
    public int qts() {
        return this.qts;
    }

    public final ImmutableUpdateNewEncryptedMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateNewEncryptedMessage(value, this.message, this.qts);
    }

    public final ImmutableUpdateNewEncryptedMessage withMessage(EncryptedMessage value) {
        if (this.message == value) {
            return this;
        }
        EncryptedMessage newValue = Objects.requireNonNull(value, "message");
        return new ImmutableUpdateNewEncryptedMessage(this.identifier, newValue, this.qts);
    }

    public final ImmutableUpdateNewEncryptedMessage withQts(int value) {
        if (this.qts == value) {
            return this;
        }
        return new ImmutableUpdateNewEncryptedMessage(this.identifier, this.message, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateNewEncryptedMessage && this.equalTo(0, (ImmutableUpdateNewEncryptedMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateNewEncryptedMessage another) {
        return this.identifier == another.identifier && this.message.equals(another.message) && this.qts == another.qts;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.qts;
        return h;
    }

    public String toString() {
        return "UpdateNewEncryptedMessage{identifier=" + this.identifier + ", message=" + this.message + ", qts=" + this.qts + "}";
    }

    public static ImmutableUpdateNewEncryptedMessage of(EncryptedMessage message, int qts) {
        return new ImmutableUpdateNewEncryptedMessage(message, qts);
    }

    public static ImmutableUpdateNewEncryptedMessage copyOf(UpdateNewEncryptedMessage instance) {
        if (instance instanceof ImmutableUpdateNewEncryptedMessage) {
            return (ImmutableUpdateNewEncryptedMessage)instance;
        }
        return ImmutableUpdateNewEncryptedMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long INIT_BIT_QTS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private EncryptedMessage message;
        private int qts;

        private Builder() {
        }

        public final Builder from(UpdateNewEncryptedMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(QtsUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateNewEncryptedMessage) {
                instance = (UpdateNewEncryptedMessage)object;
                this.message(instance.message());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.qts(instance.qts());
                    bits |= 2L;
                }
            }
            if (object instanceof QtsUpdate) {
                instance = (QtsUpdate)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.qts(instance.qts());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder message(EncryptedMessage message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder qts(int qts) {
            this.qts = qts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateNewEncryptedMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateNewEncryptedMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("qts");
            }
            return "Cannot build UpdateNewEncryptedMessage, some of required attributes are not set " + attributes;
        }
    }
}

