/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Message;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateNewMessageFields;
import telegram4j.tl.UpdateNewScheduledMessage;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateNewScheduledMessage
implements UpdateNewScheduledMessage {
    private final int identifier;
    private final Message message;

    private ImmutableUpdateNewScheduledMessage(Message message) {
        this.message = Objects.requireNonNull(message, "message");
        this.identifier = UpdateNewScheduledMessage.super.identifier();
    }

    private ImmutableUpdateNewScheduledMessage(Builder builder) {
        this.message = builder.message;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateNewScheduledMessage.super.identifier();
    }

    private ImmutableUpdateNewScheduledMessage(int identifier, Message message) {
        this.identifier = identifier;
        this.message = message;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Message message() {
        return this.message;
    }

    public final ImmutableUpdateNewScheduledMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateNewScheduledMessage(value, this.message);
    }

    public final ImmutableUpdateNewScheduledMessage withMessage(Message value) {
        if (this.message == value) {
            return this;
        }
        Message newValue = Objects.requireNonNull(value, "message");
        return new ImmutableUpdateNewScheduledMessage(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateNewScheduledMessage && this.equalTo(0, (ImmutableUpdateNewScheduledMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateNewScheduledMessage another) {
        return this.identifier == another.identifier && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateNewScheduledMessage{identifier=" + this.identifier + ", message=" + this.message + "}";
    }

    public static ImmutableUpdateNewScheduledMessage of(Message message) {
        return new ImmutableUpdateNewScheduledMessage(message);
    }

    public static ImmutableUpdateNewScheduledMessage copyOf(UpdateNewScheduledMessage instance) {
        if (instance instanceof ImmutableUpdateNewScheduledMessage) {
            return (ImmutableUpdateNewScheduledMessage)instance;
        }
        return ImmutableUpdateNewScheduledMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Message message;

        private Builder() {
        }

        public final Builder from(UpdateNewMessageFields instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateNewScheduledMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateNewMessageFields) {
                instance = (UpdateNewMessageFields)object;
                if ((bits & 2L) == 0L) {
                    this.message(instance.message());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateNewScheduledMessage) {
                instance = (UpdateNewScheduledMessage)object;
                if ((bits & 2L) == 0L) {
                    this.message(instance.message());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder message(Message message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateNewScheduledMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateNewScheduledMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build UpdateNewScheduledMessage, some of required attributes are not set " + attributes;
        }
    }
}

