/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateNewStickerSet;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.StickerSetWithDocuments;

public final class ImmutableUpdateNewStickerSet
implements UpdateNewStickerSet {
    private final int identifier;
    private final StickerSetWithDocuments stickerset;

    private ImmutableUpdateNewStickerSet(StickerSetWithDocuments stickerset) {
        this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
        this.identifier = UpdateNewStickerSet.super.identifier();
    }

    private ImmutableUpdateNewStickerSet(Builder builder) {
        this.stickerset = builder.stickerset;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateNewStickerSet.super.identifier();
    }

    private ImmutableUpdateNewStickerSet(int identifier, StickerSetWithDocuments stickerset) {
        this.identifier = identifier;
        this.stickerset = stickerset;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public StickerSetWithDocuments stickerset() {
        return this.stickerset;
    }

    public final ImmutableUpdateNewStickerSet withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateNewStickerSet(value, this.stickerset);
    }

    public final ImmutableUpdateNewStickerSet withStickerset(StickerSetWithDocuments value) {
        if (this.stickerset == value) {
            return this;
        }
        StickerSetWithDocuments newValue = Objects.requireNonNull(value, "stickerset");
        return new ImmutableUpdateNewStickerSet(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateNewStickerSet && this.equalTo(0, (ImmutableUpdateNewStickerSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateNewStickerSet another) {
        return this.identifier == another.identifier && this.stickerset.equals(another.stickerset);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.stickerset.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateNewStickerSet{identifier=" + this.identifier + ", stickerset=" + this.stickerset + "}";
    }

    public static ImmutableUpdateNewStickerSet of(StickerSetWithDocuments stickerset) {
        return new ImmutableUpdateNewStickerSet(stickerset);
    }

    public static ImmutableUpdateNewStickerSet copyOf(UpdateNewStickerSet instance) {
        if (instance instanceof ImmutableUpdateNewStickerSet) {
            return (ImmutableUpdateNewStickerSet)instance;
        }
        return ImmutableUpdateNewStickerSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_STICKERSET = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private StickerSetWithDocuments stickerset;

        private Builder() {
        }

        public final Builder from(UpdateNewStickerSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateNewStickerSet) {
                instance = (UpdateNewStickerSet)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.stickerset(instance.stickerset());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder stickerset(StickerSetWithDocuments stickerset) {
            this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateNewStickerSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateNewStickerSet(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stickerset");
            }
            return "Cannot build UpdateNewStickerSet, some of required attributes are not set " + attributes;
        }
    }
}

