/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.NotifyPeer;
import telegram4j.tl.PeerNotifySettings;
import telegram4j.tl.Update;
import telegram4j.tl.UpdateNotifySettings;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdateNotifySettings
implements UpdateNotifySettings {
    private final int identifier;
    private final NotifyPeer peer;
    private final PeerNotifySettings notifySettings;

    private ImmutableUpdateNotifySettings(NotifyPeer peer, PeerNotifySettings notifySettings) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.notifySettings = Objects.requireNonNull(notifySettings, "notifySettings");
        this.identifier = UpdateNotifySettings.super.identifier();
    }

    private ImmutableUpdateNotifySettings(Builder builder) {
        this.peer = builder.peer;
        this.notifySettings = builder.notifySettings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateNotifySettings.super.identifier();
    }

    private ImmutableUpdateNotifySettings(int identifier, NotifyPeer peer, PeerNotifySettings notifySettings) {
        this.identifier = identifier;
        this.peer = peer;
        this.notifySettings = notifySettings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public NotifyPeer peer() {
        return this.peer;
    }

    @Override
    public PeerNotifySettings notifySettings() {
        return this.notifySettings;
    }

    public final ImmutableUpdateNotifySettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateNotifySettings(value, this.peer, this.notifySettings);
    }

    public final ImmutableUpdateNotifySettings withPeer(NotifyPeer value) {
        if (this.peer == value) {
            return this;
        }
        NotifyPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateNotifySettings(this.identifier, newValue, this.notifySettings);
    }

    public final ImmutableUpdateNotifySettings withNotifySettings(PeerNotifySettings value) {
        if (this.notifySettings == value) {
            return this;
        }
        PeerNotifySettings newValue = Objects.requireNonNull(value, "notifySettings");
        return new ImmutableUpdateNotifySettings(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateNotifySettings && this.equalTo(0, (ImmutableUpdateNotifySettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateNotifySettings another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.notifySettings.equals(another.notifySettings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.notifySettings.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateNotifySettings{identifier=" + this.identifier + ", peer=" + this.peer + ", notifySettings=" + this.notifySettings + "}";
    }

    public static ImmutableUpdateNotifySettings of(NotifyPeer peer, PeerNotifySettings notifySettings) {
        return new ImmutableUpdateNotifySettings(peer, notifySettings);
    }

    public static ImmutableUpdateNotifySettings copyOf(UpdateNotifySettings instance) {
        if (instance instanceof ImmutableUpdateNotifySettings) {
            return (ImmutableUpdateNotifySettings)instance;
        }
        return ImmutableUpdateNotifySettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_NOTIFY_SETTINGS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private NotifyPeer peer;
        private PeerNotifySettings notifySettings;

        private Builder() {
        }

        public final Builder from(UpdateNotifySettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdateNotifySettings) {
                instance = (UpdateNotifySettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.notifySettings(instance.notifySettings());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(NotifyPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder notifySettings(PeerNotifySettings notifySettings) {
            this.notifySettings = Objects.requireNonNull(notifySettings, "notifySettings");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateNotifySettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateNotifySettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("notifySettings");
            }
            return "Cannot build UpdateNotifySettings, some of required attributes are not set " + attributes;
        }
    }
}

