/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Peer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdatePeerBlocked;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdatePeerBlocked
implements UpdatePeerBlocked {
    private final int identifier;
    private final Peer peerId;
    private final boolean blocked;

    private ImmutableUpdatePeerBlocked(Peer peerId, boolean blocked) {
        this.peerId = Objects.requireNonNull(peerId, "peerId");
        this.blocked = blocked;
        this.identifier = UpdatePeerBlocked.super.identifier();
    }

    private ImmutableUpdatePeerBlocked(Builder builder) {
        this.peerId = builder.peerId;
        this.blocked = builder.blocked;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdatePeerBlocked.super.identifier();
    }

    private ImmutableUpdatePeerBlocked(int identifier, Peer peerId, boolean blocked) {
        this.identifier = identifier;
        this.peerId = peerId;
        this.blocked = blocked;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peerId() {
        return this.peerId;
    }

    @Override
    public boolean blocked() {
        return this.blocked;
    }

    public final ImmutableUpdatePeerBlocked withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdatePeerBlocked(value, this.peerId, this.blocked);
    }

    public final ImmutableUpdatePeerBlocked withPeerId(Peer value) {
        if (this.peerId == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peerId");
        return new ImmutableUpdatePeerBlocked(this.identifier, newValue, this.blocked);
    }

    public final ImmutableUpdatePeerBlocked withBlocked(boolean value) {
        if (this.blocked == value) {
            return this;
        }
        return new ImmutableUpdatePeerBlocked(this.identifier, this.peerId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePeerBlocked && this.equalTo(0, (ImmutableUpdatePeerBlocked)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePeerBlocked another) {
        return this.identifier == another.identifier && this.peerId.equals(another.peerId) && this.blocked == another.blocked;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peerId.hashCode();
        h += (h << 5) + Boolean.hashCode(this.blocked);
        return h;
    }

    public String toString() {
        return "UpdatePeerBlocked{identifier=" + this.identifier + ", peerId=" + this.peerId + ", blocked=" + this.blocked + "}";
    }

    public static ImmutableUpdatePeerBlocked of(Peer peerId, boolean blocked) {
        return new ImmutableUpdatePeerBlocked(peerId, blocked);
    }

    public static ImmutableUpdatePeerBlocked copyOf(UpdatePeerBlocked instance) {
        if (instance instanceof ImmutableUpdatePeerBlocked) {
            return (ImmutableUpdatePeerBlocked)instance;
        }
        return ImmutableUpdatePeerBlocked.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER_ID = 1L;
        private static final long INIT_BIT_BLOCKED = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Peer peerId;
        private boolean blocked;

        private Builder() {
        }

        public final Builder from(UpdatePeerBlocked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdatePeerBlocked) {
                instance = (UpdatePeerBlocked)object;
                this.peerId(instance.peerId());
                this.blocked(instance.blocked());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peerId(Peer peerId) {
            this.peerId = Objects.requireNonNull(peerId, "peerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder blocked(boolean blocked) {
            this.blocked = blocked;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdatePeerBlocked build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdatePeerBlocked(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peerId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("blocked");
            }
            return "Cannot build UpdatePeerBlocked, some of required attributes are not set " + attributes;
        }
    }
}

