/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Peer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdatePeerHistoryTTL;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdatePeerHistoryTTL
implements UpdatePeerHistoryTTL {
    private final int identifier;
    private final int flags;
    private final Peer peer;
    @Nullable
    private final Integer ttlPeriod;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdatePeerHistoryTTL(Peer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.ttlPeriod = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdatePeerHistoryTTL(Builder builder) {
        this.peer = builder.peer;
        this.ttlPeriod = builder.ttlPeriod;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdatePeerHistoryTTL(int identifier, int flags, Peer peer, @Nullable Integer ttlPeriod) {
        this.identifier = identifier;
        this.flags = flags;
        this.peer = peer;
        this.ttlPeriod = ttlPeriod;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdatePeerHistoryTTL.super.identifier();
    }

    private int flagsInitialize() {
        return UpdatePeerHistoryTTL.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    @Nullable
    public Integer ttlPeriod() {
        return this.ttlPeriod;
    }

    public final ImmutableUpdatePeerHistoryTTL withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdatePeerHistoryTTL(value, this.flags, this.peer, this.ttlPeriod);
    }

    public final ImmutableUpdatePeerHistoryTTL withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdatePeerHistoryTTL(this.identifier, value, this.peer, this.ttlPeriod);
    }

    public final ImmutableUpdatePeerHistoryTTL withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdatePeerHistoryTTL(this.identifier, this.flags, newValue, this.ttlPeriod);
    }

    public final ImmutableUpdatePeerHistoryTTL withTtlPeriod(@Nullable Integer value) {
        if (Objects.equals(this.ttlPeriod, value)) {
            return this;
        }
        return new ImmutableUpdatePeerHistoryTTL(this.identifier, this.flags, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePeerHistoryTTL && this.equalTo(0, (ImmutableUpdatePeerHistoryTTL)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePeerHistoryTTL another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.peer.equals(another.peer) && Objects.equals(this.ttlPeriod, another.ttlPeriod);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Objects.hashCode(this.ttlPeriod);
        return h;
    }

    public String toString() {
        return "UpdatePeerHistoryTTL{identifier=" + this.identifier + ", flags=" + this.flags + ", peer=" + this.peer + ", ttlPeriod=" + this.ttlPeriod + "}";
    }

    public static ImmutableUpdatePeerHistoryTTL of(Peer peer) {
        return new ImmutableUpdatePeerHistoryTTL(peer);
    }

    public static ImmutableUpdatePeerHistoryTTL copyOf(UpdatePeerHistoryTTL instance) {
        if (instance instanceof ImmutableUpdatePeerHistoryTTL) {
            return (ImmutableUpdatePeerHistoryTTL)instance;
        }
        return ImmutableUpdatePeerHistoryTTL.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private Peer peer;
        private Integer ttlPeriod;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdatePeerHistoryTTL instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdatePeerHistoryTTL) {
                Integer ttlPeriodValue;
                instance = (UpdatePeerHistoryTTL)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((ttlPeriodValue = instance.ttlPeriod()) != null) {
                    this.ttlPeriod(ttlPeriodValue);
                }
                this.peer(instance.peer());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ttlPeriod(@Nullable Integer ttlPeriod) {
            this.ttlPeriod = ttlPeriod;
            return this;
        }

        public ImmutableUpdatePeerHistoryTTL build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdatePeerHistoryTTL(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build UpdatePeerHistoryTTL, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdatePeerHistoryTTL.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdatePeerHistoryTTL.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdatePeerHistoryTTL, attribute initializers form cycle " + attributes;
        }
    }
}

