/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PeerLocated;
import telegram4j.tl.Update;
import telegram4j.tl.UpdatePeerLocated;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdatePeerLocated
implements UpdatePeerLocated {
    private final int identifier;
    private final List<PeerLocated> peers;

    private ImmutableUpdatePeerLocated(Builder builder) {
        this.peers = ImmutableUpdatePeerLocated.createUnmodifiableList(true, builder.peers);
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdatePeerLocated.super.identifier();
    }

    private ImmutableUpdatePeerLocated(int identifier, List<PeerLocated> peers) {
        this.identifier = identifier;
        this.peers = peers;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<PeerLocated> peers() {
        return this.peers;
    }

    public final ImmutableUpdatePeerLocated withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdatePeerLocated(value, this.peers);
    }

    public final ImmutableUpdatePeerLocated withPeers(PeerLocated ... elements) {
        List<PeerLocated> newValue = ImmutableUpdatePeerLocated.createUnmodifiableList(false, ImmutableUpdatePeerLocated.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUpdatePeerLocated(this.identifier, newValue);
    }

    public final ImmutableUpdatePeerLocated withPeers(Iterable<? extends PeerLocated> elements) {
        if (this.peers == elements) {
            return this;
        }
        List<PeerLocated> newValue = ImmutableUpdatePeerLocated.createUnmodifiableList(false, ImmutableUpdatePeerLocated.createSafeList(elements, true, false));
        return new ImmutableUpdatePeerLocated(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePeerLocated && this.equalTo(0, (ImmutableUpdatePeerLocated)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePeerLocated another) {
        return this.identifier == another.identifier && this.peers.equals(another.peers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peers.hashCode();
        return h;
    }

    public String toString() {
        return "UpdatePeerLocated{identifier=" + this.identifier + ", peers=" + this.peers + "}";
    }

    public static ImmutableUpdatePeerLocated copyOf(UpdatePeerLocated instance) {
        if (instance instanceof ImmutableUpdatePeerLocated) {
            return (ImmutableUpdatePeerLocated)instance;
        }
        return ImmutableUpdatePeerLocated.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<PeerLocated> peers = new ArrayList<PeerLocated>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdatePeerLocated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdatePeerLocated) {
                instance = (UpdatePeerLocated)object;
                this.addAllPeers(instance.peers());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addPeer(PeerLocated element) {
            this.peers.add(Objects.requireNonNull(element, "peers element"));
            return this;
        }

        public final Builder addPeers(PeerLocated ... elements) {
            for (PeerLocated element : elements) {
                this.peers.add(Objects.requireNonNull(element, "peers element"));
            }
            return this;
        }

        public final Builder peers(Iterable<? extends PeerLocated> elements) {
            this.peers.clear();
            return this.addAllPeers(elements);
        }

        public final Builder addAllPeers(Iterable<? extends PeerLocated> elements) {
            for (PeerLocated peerLocated : elements) {
                this.peers.add(Objects.requireNonNull(peerLocated, "peers element"));
            }
            return this;
        }

        public ImmutableUpdatePeerLocated build() {
            return new ImmutableUpdatePeerLocated(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

