/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Peer;
import telegram4j.tl.PeerSettings;
import telegram4j.tl.Update;
import telegram4j.tl.UpdatePeerSettings;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdatePeerSettings
implements UpdatePeerSettings {
    private final int identifier;
    private final Peer peer;
    private final PeerSettings settings;

    private ImmutableUpdatePeerSettings(Peer peer, PeerSettings settings) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.settings = Objects.requireNonNull(settings, "settings");
        this.identifier = UpdatePeerSettings.super.identifier();
    }

    private ImmutableUpdatePeerSettings(Builder builder) {
        this.peer = builder.peer;
        this.settings = builder.settings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdatePeerSettings.super.identifier();
    }

    private ImmutableUpdatePeerSettings(int identifier, Peer peer, PeerSettings settings) {
        this.identifier = identifier;
        this.peer = peer;
        this.settings = settings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public PeerSettings settings() {
        return this.settings;
    }

    public final ImmutableUpdatePeerSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdatePeerSettings(value, this.peer, this.settings);
    }

    public final ImmutableUpdatePeerSettings withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdatePeerSettings(this.identifier, newValue, this.settings);
    }

    public final ImmutableUpdatePeerSettings withSettings(PeerSettings value) {
        if (this.settings == value) {
            return this;
        }
        PeerSettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableUpdatePeerSettings(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePeerSettings && this.equalTo(0, (ImmutableUpdatePeerSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePeerSettings another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.settings.equals(another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.settings.hashCode();
        return h;
    }

    public String toString() {
        return "UpdatePeerSettings{identifier=" + this.identifier + ", peer=" + this.peer + ", settings=" + this.settings + "}";
    }

    public static ImmutableUpdatePeerSettings of(Peer peer, PeerSettings settings) {
        return new ImmutableUpdatePeerSettings(peer, settings);
    }

    public static ImmutableUpdatePeerSettings copyOf(UpdatePeerSettings instance) {
        if (instance instanceof ImmutableUpdatePeerSettings) {
            return (ImmutableUpdatePeerSettings)instance;
        }
        return ImmutableUpdatePeerSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_SETTINGS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private PeerSettings settings;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdatePeerSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdatePeerSettings) {
                instance = (UpdatePeerSettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
                this.peer(instance.peer());
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder settings(PeerSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdatePeerSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdatePeerSettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build UpdatePeerSettings, some of required attributes are not set " + attributes;
        }
    }
}

