/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Peer;
import telegram4j.tl.Update;
import telegram4j.tl.UpdatePendingJoinRequests;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdatePendingJoinRequests
implements UpdatePendingJoinRequests {
    private final int identifier;
    private final Peer peer;
    private final int requestsPending;
    private final List<Long> recentRequesters;

    private ImmutableUpdatePendingJoinRequests(Peer peer, int requestsPending) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.requestsPending = requestsPending;
        this.recentRequesters = Collections.emptyList();
        this.identifier = UpdatePendingJoinRequests.super.identifier();
    }

    private ImmutableUpdatePendingJoinRequests(Builder builder) {
        this.peer = builder.peer;
        this.requestsPending = builder.requestsPending;
        this.recentRequesters = ImmutableUpdatePendingJoinRequests.createUnmodifiableList(true, builder.recentRequesters);
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdatePendingJoinRequests.super.identifier();
    }

    private ImmutableUpdatePendingJoinRequests(int identifier, Peer peer, int requestsPending, List<Long> recentRequesters) {
        this.identifier = identifier;
        this.peer = peer;
        this.requestsPending = requestsPending;
        this.recentRequesters = recentRequesters;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public int requestsPending() {
        return this.requestsPending;
    }

    @Override
    public List<Long> recentRequesters() {
        return this.recentRequesters;
    }

    public final ImmutableUpdatePendingJoinRequests withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdatePendingJoinRequests(value, this.peer, this.requestsPending, this.recentRequesters);
    }

    public final ImmutableUpdatePendingJoinRequests withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdatePendingJoinRequests(this.identifier, newValue, this.requestsPending, this.recentRequesters);
    }

    public final ImmutableUpdatePendingJoinRequests withRequestsPending(int value) {
        if (this.requestsPending == value) {
            return this;
        }
        return new ImmutableUpdatePendingJoinRequests(this.identifier, this.peer, value, this.recentRequesters);
    }

    public final ImmutableUpdatePendingJoinRequests withRecentRequesters(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableUpdatePendingJoinRequests.createUnmodifiableList(false, wrappedList);
        return new ImmutableUpdatePendingJoinRequests(this.identifier, this.peer, this.requestsPending, newValue);
    }

    public final ImmutableUpdatePendingJoinRequests withRecentRequesters(Iterable<Long> elements) {
        if (this.recentRequesters == elements) {
            return this;
        }
        List<Long> newValue = ImmutableUpdatePendingJoinRequests.createUnmodifiableList(false, ImmutableUpdatePendingJoinRequests.createSafeList(elements, true, false));
        return new ImmutableUpdatePendingJoinRequests(this.identifier, this.peer, this.requestsPending, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePendingJoinRequests && this.equalTo(0, (ImmutableUpdatePendingJoinRequests)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePendingJoinRequests another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.requestsPending == another.requestsPending && this.recentRequesters.equals(another.recentRequesters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.requestsPending;
        h += (h << 5) + this.recentRequesters.hashCode();
        return h;
    }

    public String toString() {
        return "UpdatePendingJoinRequests{identifier=" + this.identifier + ", peer=" + this.peer + ", requestsPending=" + this.requestsPending + ", recentRequesters=" + this.recentRequesters + "}";
    }

    public static ImmutableUpdatePendingJoinRequests of(Peer peer, int requestsPending) {
        return new ImmutableUpdatePendingJoinRequests(peer, requestsPending);
    }

    public static ImmutableUpdatePendingJoinRequests copyOf(UpdatePendingJoinRequests instance) {
        if (instance instanceof ImmutableUpdatePendingJoinRequests) {
            return (ImmutableUpdatePendingJoinRequests)instance;
        }
        return ImmutableUpdatePendingJoinRequests.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_REQUESTS_PENDING = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private int requestsPending;
        private List<Long> recentRequesters = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(UpdatePendingJoinRequests instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdatePendingJoinRequests) {
                instance = (UpdatePendingJoinRequests)object;
                this.addAllRecentRequesters(instance.recentRequesters());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.requestsPending(instance.requestsPending());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder requestsPending(int requestsPending) {
            this.requestsPending = requestsPending;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addRecentRequester(long element) {
            this.recentRequesters.add(element);
            return this;
        }

        public final Builder addRecentRequesters(long ... elements) {
            for (long element : elements) {
                this.recentRequesters.add(element);
            }
            return this;
        }

        public final Builder recentRequesters(Iterable<Long> elements) {
            this.recentRequesters.clear();
            return this.addAllRecentRequesters(elements);
        }

        public final Builder addAllRecentRequesters(Iterable<Long> elements) {
            for (Long element : elements) {
                this.recentRequesters.add(Objects.requireNonNull(element, "recentRequesters element"));
            }
            return this;
        }

        public ImmutableUpdatePendingJoinRequests build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdatePendingJoinRequests(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("requestsPending");
            }
            return "Cannot build UpdatePendingJoinRequests, some of required attributes are not set " + attributes;
        }
    }
}

