/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.PhoneCall;
import telegram4j.tl.Update;
import telegram4j.tl.UpdatePhoneCall;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdatePhoneCall
implements UpdatePhoneCall {
    private final int identifier;
    private final PhoneCall phoneCall;

    private ImmutableUpdatePhoneCall(PhoneCall phoneCall) {
        this.phoneCall = Objects.requireNonNull(phoneCall, "phoneCall");
        this.identifier = UpdatePhoneCall.super.identifier();
    }

    private ImmutableUpdatePhoneCall(Builder builder) {
        this.phoneCall = builder.phoneCall;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdatePhoneCall.super.identifier();
    }

    private ImmutableUpdatePhoneCall(int identifier, PhoneCall phoneCall) {
        this.identifier = identifier;
        this.phoneCall = phoneCall;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public PhoneCall phoneCall() {
        return this.phoneCall;
    }

    public final ImmutableUpdatePhoneCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdatePhoneCall(value, this.phoneCall);
    }

    public final ImmutableUpdatePhoneCall withPhoneCall(PhoneCall value) {
        if (this.phoneCall == value) {
            return this;
        }
        PhoneCall newValue = Objects.requireNonNull(value, "phoneCall");
        return new ImmutableUpdatePhoneCall(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePhoneCall && this.equalTo(0, (ImmutableUpdatePhoneCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePhoneCall another) {
        return this.identifier == another.identifier && this.phoneCall.equals(another.phoneCall);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneCall.hashCode();
        return h;
    }

    public String toString() {
        return "UpdatePhoneCall{identifier=" + this.identifier + ", phoneCall=" + this.phoneCall + "}";
    }

    public static ImmutableUpdatePhoneCall of(PhoneCall phoneCall) {
        return new ImmutableUpdatePhoneCall(phoneCall);
    }

    public static ImmutableUpdatePhoneCall copyOf(UpdatePhoneCall instance) {
        if (instance instanceof ImmutableUpdatePhoneCall) {
            return (ImmutableUpdatePhoneCall)instance;
        }
        return ImmutableUpdatePhoneCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private PhoneCall phoneCall;

        private Builder() {
        }

        public final Builder from(UpdatePhoneCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdatePhoneCall) {
                instance = (UpdatePhoneCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phoneCall(instance.phoneCall());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneCall(PhoneCall phoneCall) {
            this.phoneCall = Objects.requireNonNull(phoneCall, "phoneCall");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdatePhoneCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdatePhoneCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneCall");
            }
            return "Cannot build UpdatePhoneCall, some of required attributes are not set " + attributes;
        }
    }
}

