/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Update;
import telegram4j.tl.UpdatePhoneCallSignalingData;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableUpdatePhoneCallSignalingData
implements UpdatePhoneCallSignalingData {
    private final int identifier;
    private final long phoneCallId;
    private final ByteBuf data;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdatePhoneCallSignalingData(long phoneCallId) {
        this.phoneCallId = phoneCallId;
        this.data = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableUpdatePhoneCallSignalingData(Builder builder) {
        this.phoneCallId = builder.phoneCallId;
        this.data = builder.data_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableUpdatePhoneCallSignalingData(int identifier, long phoneCallId, ByteBuf data) {
        this.identifier = identifier;
        this.phoneCallId = phoneCallId;
        this.data = data;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdatePhoneCallSignalingData.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long phoneCallId() {
        return this.phoneCallId;
    }

    @Override
    public ByteBuf data() {
        return this.data.duplicate();
    }

    public final ImmutableUpdatePhoneCallSignalingData withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdatePhoneCallSignalingData(value, this.phoneCallId, this.data);
    }

    public final ImmutableUpdatePhoneCallSignalingData withPhoneCallId(long value) {
        if (this.phoneCallId == value) {
            return this;
        }
        return new ImmutableUpdatePhoneCallSignalingData(this.identifier, value, this.data);
    }

    public ImmutableUpdatePhoneCallSignalingData withData(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableUpdatePhoneCallSignalingData(this.identifier, this.phoneCallId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePhoneCallSignalingData && this.equalTo(0, (ImmutableUpdatePhoneCallSignalingData)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePhoneCallSignalingData another) {
        return this.identifier == another.identifier && this.phoneCallId == another.phoneCallId && this.data().equals((Object)another.data());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.phoneCallId);
        h += (h << 5) + this.data().hashCode();
        return h;
    }

    public String toString() {
        return "UpdatePhoneCallSignalingData{identifier=" + this.identifier + ", phoneCallId=" + this.phoneCallId + ", data=" + ByteBufUtil.hexDump((ByteBuf)this.data) + "}";
    }

    public static ImmutableUpdatePhoneCallSignalingData of(long phoneCallId) {
        return new ImmutableUpdatePhoneCallSignalingData(phoneCallId);
    }

    public static ImmutableUpdatePhoneCallSignalingData copyOf(UpdatePhoneCallSignalingData instance) {
        if (instance instanceof ImmutableUpdatePhoneCallSignalingData) {
            return (ImmutableUpdatePhoneCallSignalingData)instance;
        }
        return ImmutableUpdatePhoneCallSignalingData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_CALL_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf data_value = null;
        private int identifier;
        private long phoneCallId;

        private Builder() {
        }

        public final Builder from(UpdatePhoneCallSignalingData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Update instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Update instance;
            long bits = 0L;
            if (object instanceof UpdatePhoneCallSignalingData) {
                instance = (UpdatePhoneCallSignalingData)object;
                this.data(instance.data());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phoneCallId(instance.phoneCallId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Update) {
                instance = (Update)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneCallId(long phoneCallId) {
            this.phoneCallId = phoneCallId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder data(ByteBuf value) {
            this.data_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableUpdatePhoneCallSignalingData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdatePhoneCallSignalingData(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneCallId");
            }
            return "Cannot build UpdatePhoneCallSignalingData, some of required attributes are not set " + attributes;
        }

        private ByteBuf data_build() {
            return Objects.requireNonNull(this.data_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdatePhoneCallSignalingData.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build UpdatePhoneCallSignalingData, attribute initializers form cycle " + attributes;
        }
    }
}

